/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class RegexValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        String regex = (String)value;
        if ("*".equals(regex)) {
            throw new ConfigException(name, value, "* is not a valid regex. To select all topics, use .* instead");
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException(name, value, e.getMessage());
        }
    }
}

