/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class UrlSelector {
    private int index;
    private final List<String> urls;
    private int failures;

    public UrlSelector(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one metadata server URL to be passed in constructor");
        }
        this.urls = new ArrayList<String>(urls);
        this.index = new Random().nextInt(urls.size());
        this.failures = 0;
    }

    public String current() {
        return this.urls.get(this.index);
    }

    public void fail() {
        this.index = (this.index + 1) % this.urls.size();
        ++this.failures;
    }

    public int round() {
        return Math.floorDiv(this.failures, this.size());
    }

    public int failures() {
        return this.failures;
    }

    public int size() {
        return this.urls.size();
    }

    public int index() {
        return this.index;
    }

    public String toString() {
        return this.urls.toString();
    }
}

