/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.common;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class JwtBearerToken
implements OAuthBearerToken {
    private final String jwtId;
    private final String value;
    private final String principalName;
    private final Set<String> scope;
    private final long lifetimeMs;
    private final Long startTimeMs;
    private final JwtClaims jwtClaims;

    public JwtBearerToken(String value, Set<String> scope, long lifetimeMs, String principalName, Long startTimeMs, String jwtId) {
        this.value = value;
        this.principalName = principalName;
        this.scope = scope;
        this.lifetimeMs = lifetimeMs;
        this.startTimeMs = startTimeMs;
        this.jwtId = jwtId;
        this.jwtClaims = new JwtClaims();
    }

    public JwtBearerToken(String value) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipAllDefaultValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        try {
            this.jwtClaims = jwtConsumer.processToClaims(value);
            this.value = value;
            this.principalName = this.jwtClaims.getSubject();
            this.scope = Collections.emptySet();
            this.lifetimeMs = this.jwtClaims.getExpirationTime().getValueInMillis();
            this.startTimeMs = this.jwtClaims.getIssuedAt().getValueInMillis();
            this.jwtId = this.jwtClaims.getJwtId();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new ConfigException("Failed to construct JwtBearerToken", (Object)e);
        }
    }

    public String value() {
        return this.value;
    }

    public Set<String> scope() {
        return Collections.unmodifiableSet(this.scope);
    }

    public long lifetimeMs() {
        return this.lifetimeMs;
    }

    public String principalName() {
        return this.principalName;
    }

    public Long startTimeMs() {
        return this.startTimeMs;
    }

    public String jwtId() {
        return this.jwtId;
    }

    public JwtClaims jwtClaims() {
        return this.jwtClaims;
    }
}

