/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.common.metrics.JmxReporter;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.MetricsReporter;
import io.confluent.rest.ApplicationServer;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import io.confluent.rest.extension.ResourceExtension;
import io.confluent.rest.metrics.MetricsResourceMethodApplicationListener;
import io.confluent.rest.validation.JacksonMessageBodyProvider;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application<T extends RestConfig> {
    protected T config;
    private final String path;
    protected ApplicationServer server;
    protected Metrics metrics;
    protected final Slf4jRequestLog requestLog;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected final List<ResourceExtension> resourceExtensions = new ArrayList<ResourceExtension>();
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public Application(T config) {
        this(config, "/");
    }

    public Application(T config, String path) {
        this.config = config;
        this.path = Objects.requireNonNull(path);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter(config.getString("metrics.jmx.prefix")));
        this.metrics = new Metrics(metricConfig, reporters, ((RestConfig)((Object)config)).getTime());
        this.getMetricsTags().putAll(Application.parseListToMap(config.getList("metrics.tag.map")));
        this.requestLog = new Slf4jRequestLog();
        this.requestLog.setLoggerName(config.getString("request.logger.name"));
        this.requestLog.setLogLatency(true);
    }

    public final String getPath() {
        return this.path;
    }

    public abstract void setupResources(Configurable<?> var1, T var2);

    protected ResourceCollection getStaticResources() {
        return null;
    }

    protected void configurePreResourceHandling(ServletContextHandler context) {
    }

    protected SslContextFactory getSslContextFactory() {
        return this.server.getSslContextFactory();
    }

    protected void configurePostResourceHandling(ServletContextHandler context) {
    }

    protected void configureWebSocketPostResourceHandling(ServletContextHandler context) {
    }

    public Map<String, String> getMetricsTags() {
        return new LinkedHashMap<String, String>();
    }

    public Server createServer() throws ServletException {
        if (this.server == null) {
            this.server = new ApplicationServer<T>(this.config);
            this.server.registerApplication(this);
        }
        return this.server;
    }

    final void setServer(ApplicationServer server) {
        this.server = Objects.requireNonNull(server);
    }

    final ApplicationServer getServer() {
        return this.server;
    }

    final Handler configureHandler() {
        ResourceConfig resourceConfig = new ResourceConfig();
        this.configureBaseApplication((Configurable<?>)resourceConfig, this.getMetricsTags());
        this.configureResourceExtensions(resourceConfig);
        this.setupResources((Configurable<?>)resourceConfig, this.getConfiguration());
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        FilterHolder servletHolder = new FilterHolder((Filter)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(this.path);
        ServletHolder defaultHolder = new ServletHolder("default", DefaultServlet.class);
        defaultHolder.setInitParameter("dirAllowed", "false");
        ResourceCollection staticResources = this.getStaticResources();
        if (staticResources != null) {
            context.setBaseResource((Resource)staticResources);
        }
        this.configureSecurityHandler(context);
        if (this.isCorsEnabled()) {
            String allowedOrigins = this.config.getString("access.control.allow.origin");
            FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.config.getString("access.control.allow.methods");
            String allowedHeaders = this.config.getString("access.control.allow.headers");
            if (allowedMethods != null && !allowedMethods.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            if (allowedHeaders != null && !allowedHeaders.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedHeaders", allowedHeaders);
            }
            filterHolder.setInitParameter("chainPreflight", "false");
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        this.configurePreResourceHandling(context);
        context.addFilter(servletHolder, "/*", null);
        this.configurePostResourceHandling(context);
        context.addServlet(defaultHolder, "/*");
        this.applyCustomConfiguration(context, "rest.servlet.initializor.classes");
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog((RequestLog)this.requestLog);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{context, requestLogHandler});
        return handlers;
    }

    final Handler configureWebSocketHandler() throws ServletException {
        ServletContextHandler webSocketContext = new ServletContextHandler(1);
        webSocketContext.setContextPath(this.config.getString("websocket.path.prefix"));
        this.configureSecurityHandler(webSocketContext);
        ServerContainer container = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)webSocketContext);
        this.registerWebSocketEndpoints(container);
        this.configureWebSocketPostResourceHandling(webSocketContext);
        this.applyCustomConfiguration(webSocketContext, "websocket.servlet.initializor.classes");
        return webSocketContext;
    }

    public static Map<String, String> parseListToMap(List<String> list) {
        HashMap<String, String> configuredTags = new HashMap<String, String>();
        for (String entry : list) {
            String[] keyValue = entry.split("\\s*:\\s*", -1);
            if (keyValue.length != 2) {
                throw new ConfigException("Map entry should be of form <key>:<value");
            }
            configuredTags.put(keyValue[0], keyValue[1]);
        }
        return configuredTags;
    }

    private boolean isCorsEnabled() {
        return AuthUtil.isCorsEnabled(this.config);
    }

    private void configureResourceExtensions(ResourceConfig resourceConfig) {
        this.resourceExtensions.addAll(this.getConfiguration().getConfiguredInstances("resource.extension.classes", ResourceExtension.class));
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.register((Configurable<?>)resourceConfig, this);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception throw by resource extension. ext:" + ext, e);
            }
        });
    }

    private void applyCustomConfiguration(ServletContextHandler context, String initializerConfigName) {
        this.getConfiguration().getConfiguredInstances(initializerConfigName, Consumer.class).forEach(initializer -> {
            try {
                initializer.accept(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception from custom initializer. config:" + initializerConfigName + ", initializer" + initializer, e);
            }
        });
    }

    protected void configureSecurityHandler(ServletContextHandler context) {
        String authMethod = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(authMethod)) {
            context.setSecurityHandler((SecurityHandler)this.createBasicSecurityHandler());
        } else if (Application.enableBearerAuth(authMethod)) {
            context.setSecurityHandler((SecurityHandler)this.createBearerSecurityHandler());
        }
    }

    public Handler wrapWithGzipHandler(Handler handler) {
        return ApplicationServer.wrapWithGzipHandler(this.config, handler);
    }

    public static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        return ApplicationServer.parseListeners(listenersConfig, deprecatedPort, supportedSchemes, defaultScheme);
    }

    protected void registerWebSocketEndpoints(ServerContainer container) {
    }

    static boolean enableBasicAuth(String authMethod) {
        return "BASIC".equals(authMethod);
    }

    static boolean enableBearerAuth(String authMethod) {
        return "BEARER".equals(authMethod);
    }

    protected LoginAuthenticator createAuthenticator() {
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method)) {
            return new BasicAuthenticator();
        }
        if (Application.enableBearerAuth(method)) {
            throw new UnsupportedOperationException("Must implement Application.createAuthenticator() when using 'authentication.method=BEARER'.");
        }
        return null;
    }

    protected LoginService createLoginService() {
        String realm = this.config.getString("authentication.realm");
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method)) {
            return new JAASLoginService(realm);
        }
        if (Application.enableBearerAuth(method)) {
            throw new UnsupportedOperationException("Must implement Application.createLoginService() when using 'authentication.method=BEARER'.");
        }
        return null;
    }

    protected IdentityService createIdentityService() {
        String method = this.config.getString("authentication.method");
        if (Application.enableBasicAuth(method) || Application.enableBearerAuth(method)) {
            return new DefaultIdentityService();
        }
        return null;
    }

    protected ConstraintSecurityHandler createBasicSecurityHandler() {
        return this.createSecurityHandler();
    }

    protected ConstraintSecurityHandler createBearerSecurityHandler() {
        return this.createSecurityHandler();
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createGlobalAuthConstraint());
        securityHandler.setAuthenticator((Authenticator)this.createAuthenticator());
        securityHandler.setLoginService(this.createLoginService());
        securityHandler.setIdentityService(this.createIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints(this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected ConstraintMapping createGlobalAuthConstraint() {
        return AuthUtil.createGlobalAuthConstraint(this.config);
    }

    public void configureBaseApplication(Configurable<?> config) {
        this.configureBaseApplication(config, null);
    }

    public void configureBaseApplication(Configurable<?> config, Map<String, String> metricTags) {
        T restConfig = this.getConfiguration();
        this.registerJsonProvider(config, restConfig, true);
        this.registerFeatures(config, restConfig);
        this.registerExceptionMappers(config, restConfig);
        config.register((Object)new MetricsResourceMethodApplicationListener(this.metrics, "jersey", metricTags, ((RestConfig)((Object)restConfig)).getTime()));
        config.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true);
        config.property("jersey.config.server.wadl.disableWadl", (Object)true);
    }

    protected void registerJsonProvider(Configurable<?> config, T restConfig, boolean registerExceptionMapper) {
        ObjectMapper jsonMapper = this.getJsonMapper();
        JacksonMessageBodyProvider jsonProvider = new JacksonMessageBodyProvider(jsonMapper);
        config.register((Object)jsonProvider);
        if (registerExceptionMapper) {
            config.register(JsonParseExceptionMapper.class);
        }
    }

    protected void registerFeatures(Configurable<?> config, T restConfig) {
        config.register(ValidationFeature.class);
    }

    protected void registerExceptionMappers(Configurable<?> config, T restConfig) {
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)((Object)restConfig)));
        config.register((Object)new GenericExceptionMapper((RestConfig)((Object)restConfig)));
    }

    public T getConfiguration() {
        return this.config;
    }

    protected ObjectMapper getJsonMapper() {
        return new ObjectMapper();
    }

    public void start() throws Exception {
        this.createServer();
        this.server.start();
    }

    public void join() throws InterruptedException {
        this.server.join();
        this.shutdownLatch.await();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    final void doShutdown() {
        this.resourceExtensions.forEach(ext -> {
            try {
                ext.close();
            }
            catch (IOException e) {
                log.error("Error closing the extension resource. ext:" + ext, (Throwable)e);
            }
        });
        this.shutdownLatch.countDown();
        this.onShutdown();
    }

    public void onShutdown() {
    }
}

