/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.common.metrics.Metrics;
import io.confluent.rest.Application;
import io.confluent.rest.ApplicationGroup;
import io.confluent.rest.FileWatcher;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationServer<T extends RestConfig>
extends Server {
    private final T config;
    private final ApplicationGroup applications;
    private final SslContextFactory sslContextFactory;
    private List<NetworkTrafficServerConnector> connectors = new ArrayList<NetworkTrafficServerConnector>();
    private static final Logger log = LoggerFactory.getLogger(ApplicationServer.class);

    public ApplicationServer(T config) {
        this.config = config;
        this.applications = new ApplicationGroup(this);
        int gracefulShutdownMs = config.getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            super.setStopTimeout((long)gracefulShutdownMs);
        }
        super.setStopAtShutdown(true);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        super.addEventListener((Container.Listener)mbContainer);
        super.addBean((Object)mbContainer);
        this.sslContextFactory = this.createSslContextFactory((RestConfig)((Object)config));
        this.configureConnectors(this.sslContextFactory);
    }

    static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://0.0.0.0:" + deprecatedPort);
        }
        ArrayList<URI> listeners = new ArrayList<URI>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            URI uri;
            try {
                uri = new URI(listenerStr);
            }
            catch (URISyntaxException use) {
                throw new ConfigException("Could not parse a listener URI from the `listener` configuration option.");
            }
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new ConfigException("Found a listener without a scheme. All listeners must have a scheme. The listener without a scheme is: " + listenerStr);
            }
            if (uri.getPort() == -1) {
                throw new ConfigException("Found a listener without a port. All listeners must have a port. The listener without a port is: " + listenerStr);
            }
            if (!supportedSchemes.contains(scheme)) {
                log.warn("Found a listener with an unsupported scheme (supported: {}). Ignoring listener '{}'", supportedSchemes, (Object)listenerStr);
                continue;
            }
            listeners.add(uri);
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    public void registerApplication(Application application) {
        this.applications.addApplication(application);
    }

    public List<Application<?>> getApplications() {
        return this.applications.getApplications();
    }

    private void attachMetricsListener(Metrics metrics, Map<String, String> tags) {
        MetricsListener metricsListener = new MetricsListener(metrics, "jetty", tags);
        for (NetworkTrafficServerConnector connector : this.connectors) {
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
        }
    }

    private void finalizeHandlerCollection(HandlerCollection handlers, HandlerCollection wsHandlers) {
        handlers.addHandler((Handler)new DefaultHandler());
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{statsHandler, wsHandlers});
        super.setHandler(this.wrapWithGzipHandler((Handler)contexts));
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.applications.doStop();
    }

    protected final void doStart() throws Exception {
        HandlerCollection handlers = new HandlerCollection();
        HandlerCollection wsHandlers = new HandlerCollection();
        for (Application<?> app : this.applications.getApplications()) {
            this.attachMetricsListener(app.metrics, app.getMetricsTags());
            handlers.addHandler(app.configureHandler());
            wsHandlers.addHandler(app.configureWebSocketHandler());
        }
        this.finalizeHandlerCollection(handlers, wsHandlers);
        super.doStart();
    }

    private void configureClientAuth(SslContextFactory sslContextFactory, RestConfig config) {
        String clientAuthentication = config.getString("ssl.client.authentication");
        if (config.originals().containsKey("ssl.client.auth")) {
            if (config.originals().containsKey("ssl.client.authentication")) {
                log.warn("The {} configuration is deprecated. Since a value has been supplied for the {} configuration, that will be used instead", (Object)"ssl.client.auth", (Object)"ssl.client.authentication");
            } else {
                log.warn("The configuration {} is deprecated and should be replaced with {}", (Object)"ssl.client.auth", (Object)"ssl.client.authentication");
                clientAuthentication = config.getBoolean("ssl.client.auth") != false ? "REQUIRED" : "NONE";
            }
        }
        switch (clientAuthentication) {
            case "REQUIRED": {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case "REQUESTED": {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
            case "NONE": {
                break;
            }
            default: {
                throw new ConfigException("Unexpected value for {} configuration: {}", (Object)"ssl.client.authentication", clientAuthentication);
            }
        }
    }

    private Path getWatchLocation(RestConfig config) {
        Path keystorePath = Paths.get(config.getString("ssl.keystore.location"), new String[0]);
        String watchLocation = config.getString("ssl.keystore.watch.location");
        if (!watchLocation.isEmpty()) {
            keystorePath = Paths.get(watchLocation, new String[0]);
        }
        return keystorePath;
    }

    private SslContextFactory createSslContextFactory(RestConfig config) {
        List cipherSuites;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (!config.getString("ssl.keystore.location").isEmpty()) {
            sslContextFactory.setKeyStorePath(config.getString("ssl.keystore.location"));
            sslContextFactory.setKeyStorePassword(config.getPassword("ssl.keystore.password").value());
            sslContextFactory.setKeyManagerPassword(config.getPassword("ssl.key.password").value());
            sslContextFactory.setKeyStoreType(config.getString("ssl.keystore.type"));
            if (!config.getString("ssl.keymanager.algorithm").isEmpty()) {
                sslContextFactory.setKeyManagerFactoryAlgorithm(config.getString("ssl.keymanager.algorithm"));
            }
            if (config.getBoolean("ssl.keystore.reload").booleanValue()) {
                Path watchLocation = this.getWatchLocation(config);
                try {
                    FileWatcher.onFileChange(watchLocation, () -> ApplicationServer.lambda$createSslContextFactory$1((SslContextFactory)sslContextFactory, config));
                    log.info("Enabled SSL cert auto reload for: " + watchLocation);
                }
                catch (IOException e) {
                    log.error("Can not enabled SSL cert auto reload", (Throwable)e);
                }
            }
        }
        this.configureClientAuth((SslContextFactory)sslContextFactory, config);
        List enabledProtocols = config.getList("ssl.enabled.protocols");
        if (!enabledProtocols.isEmpty()) {
            sslContextFactory.setIncludeProtocols(enabledProtocols.toArray(new String[0]));
        }
        if (!(cipherSuites = config.getList("ssl.cipher.suites")).isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(cipherSuites.toArray(new String[0]));
        }
        sslContextFactory.setEndpointIdentificationAlgorithm(config.getString("ssl.endpoint.identification.algorithm"));
        if (!config.getString("ssl.truststore.location").isEmpty()) {
            sslContextFactory.setTrustStorePath(config.getString("ssl.truststore.location"));
            sslContextFactory.setTrustStorePassword(config.getPassword("ssl.truststore.password").value());
            sslContextFactory.setTrustStoreType(config.getString("ssl.truststore.type"));
            if (!config.getString("ssl.trustmanager.algorithm").isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(config.getString("ssl.trustmanager.algorithm"));
            }
        }
        sslContextFactory.setProtocol(config.getString("ssl.protocol"));
        if (!config.getString("ssl.provider").isEmpty()) {
            sslContextFactory.setProtocol(config.getString("ssl.provider"));
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    private void configureConnectors(SslContextFactory sslContextFactory) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        List<URI> listeners = ApplicationServer.parseListeners(this.config.getList("listeners"), this.config.getInt("port"), Arrays.asList("http", "https"), "http");
        for (URI listener : listeners) {
            log.info("Adding listener: " + listener.toString());
            NetworkTrafficServerConnector connector = listener.getScheme().equals("http") ? new NetworkTrafficServerConnector((Server)this, (ConnectionFactory)httpConnectionFactory) : new NetworkTrafficServerConnector((Server)this, (ConnectionFactory)httpConnectionFactory, sslContextFactory);
            connector.setPort(listener.getPort());
            connector.setHost(listener.getHost());
            connector.setIdleTimeout(this.config.getLong("idle.timeout.ms").longValue());
            this.connectors.add(connector);
            super.addConnector((Connector)connector);
        }
    }

    List<URL> getListeners() {
        return Arrays.stream(this.getServer().getConnectors()).filter(connector -> connector instanceof ServerConnector).map(ServerConnector.class::cast).map(connector -> {
            try {
                String protocol = new HashSet(connector.getProtocols()).stream().map(String::toLowerCase).anyMatch(s -> s.equals("ssl")) ? "https" : "http";
                int localPort = connector.getLocalPort();
                return new URL(protocol, "localhost", localPort, "");
            }
            catch (Exception e) {
                throw new RuntimeException("Malformed listener", e);
            }
        }).collect(Collectors.toList());
    }

    static Handler wrapWithGzipHandler(RestConfig config, Handler handler) {
        if (config.getBoolean("compression.enable").booleanValue()) {
            GzipHandler gzip = new GzipHandler();
            gzip.setIncludedMethods(new String[]{"GET", "POST"});
            gzip.setHandler(handler);
            return gzip;
        }
        return handler;
    }

    private Handler wrapWithGzipHandler(Handler handler) {
        return ApplicationServer.wrapWithGzipHandler(this.config, handler);
    }

    private static /* synthetic */ void lambda$createSslContextFactory$1(SslContextFactory sslContextFactory, RestConfig config) throws Exception {
        sslContextFactory.setKeyStorePath(config.getString("ssl.keystore.location"));
        sslContextFactory.reload(scf -> log.info("Reloaded SSL cert"));
    }
}

