/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import io.confluent.rest.RestConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;

public final class AuthUtil {
    private AuthUtil() {
    }

    public static boolean isCorsEnabled(RestConfig restConfig) {
        String allowedOrigins = restConfig.getString("access.control.allow.origin");
        return !allowedOrigins.trim().isEmpty();
    }

    public static ConstraintMapping createGlobalAuthConstraint(RestConfig restConfig) {
        return AuthUtil.createConstraint(restConfig, true, "/*");
    }

    public static ConstraintMapping createSecuredConstraint(RestConfig restConfig, String pathSpec) {
        return AuthUtil.createConstraint(restConfig, true, pathSpec);
    }

    public static ConstraintMapping createUnsecuredConstraint(RestConfig restConfig, String pathSpec) {
        return AuthUtil.createConstraint(restConfig, false, pathSpec);
    }

    public static List<ConstraintMapping> createUnsecuredConstraints(RestConfig restConfig) {
        List unsecuredPaths = restConfig.getList("authentication.skip.paths");
        return unsecuredPaths.stream().map(p -> AuthUtil.createConstraint(restConfig, false, p)).collect(Collectors.toList());
    }

    private static ConstraintMapping createConstraint(RestConfig restConfig, boolean authenticate, String pathSpec) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(authenticate);
        if (authenticate) {
            List roles = restConfig.getList("authentication.roles");
            constraint.setRoles(roles.toArray(new String[0]));
        }
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("*");
        if (authenticate && AuthUtil.isCorsEnabled(restConfig)) {
            mapping.setMethodOmissions(new String[]{"OPTIONS"});
        }
        mapping.setPathSpec(pathSpec);
        return mapping;
    }
}

