/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import io.confluent.rest.handlers.SniUtils;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedSniHandler
extends Handler.Wrapper {
    private static final Logger log = LoggerFactory.getLogger(ExpectedSniHandler.class);
    private final List<String> expectedSniHeaders;

    public ExpectedSniHandler(List<String> expectedSniHeaders) {
        this.expectedSniHeaders = expectedSniHeaders;
    }

    public boolean handle(Request baseRequest, Response response, Callback callback) throws Exception {
        String sniServerName = SniUtils.getSniServerName(baseRequest);
        if (sniServerName == null) {
            log.warn("No SNI header present on request; request URI is {}", (Object)baseRequest.getHttpURI());
        } else if (!this.expectedSniHeaders.contains(sniServerName)) {
            log.warn("SNI header {} is not in the configured list of expected headers {}; request URI is {}", new Object[]{sniServerName, this.expectedSniHeaders, baseRequest.getHttpURI()});
        }
        return super.handle(baseRequest, response, callback);
    }
}

