/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.handlers;

import io.confluent.rest.handlers.SniUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniHandler
extends Handler.Wrapper {
    private static final Logger log = LoggerFactory.getLogger(SniHandler.class);

    public boolean handle(Request baseRequest, Response response, Callback callback) throws Exception {
        String serverName = Request.getServerName((Request)baseRequest);
        String sniServerName = SniUtils.getSniServerName(baseRequest);
        log.debug("host header: {}, sni value: {}", (Object)serverName, (Object)sniServerName);
        if (sniServerName != null && !sniServerName.equals(serverName)) {
            log.debug("Sni check failed, host header: {}, sni value: {}", (Object)serverName, (Object)sniServerName);
            Response.writeError((Request)baseRequest, (Response)response, (Callback)callback, (int)HttpStatus.Code.MISDIRECTED_REQUEST.getCode(), (String)HttpStatus.Code.MISDIRECTED_REQUEST.getMessage());
        }
        return super.handle(baseRequest, response, callback);
    }
}

