/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.io.NetworkTrafficListener;

public class CombinedNetworkTrafficListener
implements NetworkTrafficListener {
    private final List<NetworkTrafficListener> delegates;

    public CombinedNetworkTrafficListener(List<NetworkTrafficListener> listeners) {
        this.delegates = listeners;
    }

    public void opened(Socket socket) {
        this.delegates.forEach(listener -> listener.opened(socket));
    }

    public void incoming(Socket socket, ByteBuffer bytes) {
        this.delegates.forEach(listener -> listener.incoming(socket, bytes));
    }

    public void outgoing(Socket socket, ByteBuffer bytes) {
        this.delegates.forEach(listener -> listener.outgoing(socket, bytes));
    }

    public void closed(Socket socket) {
        this.delegates.forEach(listener -> listener.closed(socket));
    }
}

