/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.RestConstraintViolationException;
import io.confluent.rest.validation.ConstraintViolations;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public static final int UNPROCESSABLE_ENTITY_CODE = 422;
    public static final Response.StatusType UNPROCESSABLE_ENTITY = new Response.StatusType(){

        public int getStatusCode() {
            return 422;
        }

        public Response.Status.Family getFamily() {
            return Response.Status.Family.CLIENT_ERROR;
        }

        public String getReasonPhrase() {
            return "Unprocessable entity";
        }
    };

    public Response toResponse(ConstraintViolationException exception) {
        ErrorMessage message;
        if (exception instanceof RestConstraintViolationException) {
            RestConstraintViolationException restException = (RestConstraintViolationException)exception;
            message = new ErrorMessage(restException.getErrorCode(), restException.getMessage());
        } else {
            String violationMessage = ConstraintViolations.formatUntyped(exception.getConstraintViolations());
            if (violationMessage == null || violationMessage.length() == 0) {
                violationMessage = exception.getMessage();
            }
            message = new ErrorMessage(422, violationMessage);
        }
        return Response.status((int)422).entity((Object)message).build();
    }
}

