/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.BadRequestException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfTokenProtectionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CsrfTokenProtectionFilter.class);
    public static final String INVALID_TOKEN_MESSAGE = "Invalid CSRF token in request header X-Requested-With";
    public static final String MISSING_TOKEN_MESSAGE = "Missing CSRF token in request header X-Requested-With";
    public static final String MISSING_REQUESTER_MESSAGE = "Missing user session identifier in request header X-Requested-By";
    private static final Set<String> METHODS_TO_IGNORE;
    private String csrfTokenEndpoint = "/csrf";
    private int csrfTokenExpiration = 30;
    private int csrfTokenMaxEntries = 10000;
    private LoadingCache<String, String> tokenSupplier;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig.getInitParameter("csrf.prevention.token.endpoint") != null) {
            this.csrfTokenEndpoint = filterConfig.getInitParameter("csrf.prevention.token.endpoint");
        }
        if (filterConfig.getInitParameter("csrf.prevention.token.expiration.minutes") != null) {
            this.csrfTokenExpiration = Integer.parseInt(filterConfig.getInitParameter("csrf.prevention.token.expiration.minutes"));
        }
        if (filterConfig.getInitParameter("csrf.prevention.token.max.entries") != null) {
            this.csrfTokenMaxEntries = Integer.parseInt(filterConfig.getInitParameter("csrf.prevention.token.max.entries"));
        }
        this.tokenSupplier = CacheBuilder.newBuilder().expireAfterWrite((long)this.csrfTokenExpiration, TimeUnit.MINUTES).maximumSize((long)this.csrfTokenMaxEntries).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                return UUID.randomUUID().toString();
            }
        });
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String requestedBy = httpServletRequest.getHeader("X-Requested-By");
        String requestedWith = httpServletRequest.getHeader("X-Requested-With");
        if (!METHODS_TO_IGNORE.contains(httpServletRequest.getMethod())) {
            if (Strings.isNullOrEmpty((String)requestedBy)) {
                log.error("(Cross site request forgery): {}", (Object)MISSING_REQUESTER_MESSAGE);
                throw new BadRequestException(MISSING_REQUESTER_MESSAGE);
            }
            if (Strings.isNullOrEmpty((String)requestedWith)) {
                log.error("(Cross site request forgery): {}", (Object)MISSING_TOKEN_MESSAGE);
                throw new BadRequestException(MISSING_TOKEN_MESSAGE);
            }
            String cachedToken = (String)this.tokenSupplier.getIfPresent((Object)requestedBy);
            if (Strings.isNullOrEmpty((String)cachedToken) || !cachedToken.equals(requestedWith)) {
                log.error("(Cross site request forgery): {}", (Object)INVALID_TOKEN_MESSAGE);
                throw new BadRequestException(INVALID_TOKEN_MESSAGE);
            }
        }
        if (this.csrfTokenEndpoint.equals(httpServletRequest.getRequestURI())) {
            log.debug("(Cross site request forgery): Handling request for CSRF token {}", (Object)this.csrfTokenEndpoint);
            if (Strings.isNullOrEmpty((String)requestedBy)) {
                log.error("(Cross site request forgery): {}", (Object)MISSING_REQUESTER_MESSAGE);
                throw new BadRequestException(MISSING_REQUESTER_MESSAGE);
            }
            log.debug("(Cross site request forgery): Setting CSRF token on {}", (Object)this.csrfTokenEndpoint);
            httpServletResponse.setHeader("X-CONFLUENT-CSRF-TOKEN", (String)this.tokenSupplier.getUnchecked((Object)requestedBy));
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    @VisibleForTesting
    String getCsrfTokenEndpoint() {
        return this.csrfTokenEndpoint;
    }

    @VisibleForTesting
    int getCsrfTokenExpiration() {
        return this.csrfTokenExpiration;
    }

    @VisibleForTesting
    int getCsrfTokenMaxEntries() {
        return this.csrfTokenMaxEntries;
    }

    static {
        HashSet<String> mti = new HashSet<String>();
        mti.add("GET");
        mti.add("OPTIONS");
        mti.add("HEAD");
        METHODS_TO_IGNORE = Collections.unmodifiableSet(mti);
    }

    public static class Headers {
        public static final String REQUESTED_WITH = "X-Requested-With";
        public static final String REQUESTED_BY = "X-Requested-By";
        public static final String CSRF_TOKEN = "X-CONFLUENT-CSRF-TOKEN";
    }
}

