/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.jetty.DoSFilter;
import io.confluent.rest.metrics.MetricNameUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class Jetty429MetricsDosFilterListener
extends DoSFilter.Listener {
    private static final long SENSOR_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final String GROUP_NAME = "jetty-metrics";
    private Sensor fourTwoNineSensor = null;

    public Jetty429MetricsDosFilterListener(Metrics metrics, Map<String, String> metricTags, String jmxPrefix) {
        if (metrics != null) {
            String sensorNamePrefix = jmxPrefix + ":jetty-metrics";
            TreeMap<String, String> instanceMetricsTags = new TreeMap<String, String>(metricTags);
            instanceMetricsTags.put("http_status_code", "429");
            String sensorTags = instanceMetricsTags.keySet().stream().map(key -> ":" + (String)instanceMetricsTags.get(key)).collect(Collectors.joining());
            String sensorName = sensorNamePrefix + ":request-errors" + sensorTags;
            this.fourTwoNineSensor = metrics.sensor(sensorName, null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            this.fourTwoNineSensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-error-rate", "The average number of requests per second that resulted in 429 HTTP error responses in Jetty layer", instanceMetricsTags), (MeasurableStat)new Rate());
            this.fourTwoNineSensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-error-count", "A windowed count of requests that resulted in 429 HTTP error responses in Jetty layer", instanceMetricsTags), (MeasurableStat)new WindowedCount());
            this.fourTwoNineSensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-error-total", "A cumulative count of requests that resulted in 429 HTTP error responses in Jetty layer", instanceMetricsTags), (MeasurableStat)new CumulativeCount());
        }
    }

    @Override
    public DoSFilter.Action onRequestOverLimit(HttpServletRequest request, DoSFilter.OverLimit overlimit, DoSFilter dosFilter) {
        DoSFilter.Action action = DoSFilter.Action.fromDelay(dosFilter.getDelayMs());
        if (this.fourTwoNineSensor != null && action.equals((Object)DoSFilter.Action.REJECT)) {
            this.fourTwoNineSensor.record();
        }
        return action;
    }
}

