/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.credential;

import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.credential.HttpCredential;
import java.util.Objects;

public final class HttpBearerCredential
extends HttpCredential {
    private final BearerCredential credential;

    public HttpBearerCredential(String credential) {
        this(new BearerCredential(credential));
    }

    public HttpBearerCredential(BearerCredential credential) {
        this.credential = credential;
    }

    @Override
    public BearerCredential credential() {
        return this.credential;
    }

    @Override
    public HttpCredential.Scheme scheme() {
        return HttpCredential.Scheme.BEARER;
    }

    @Override
    public String authParams() {
        return this.credential.bearerToken();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpBearerCredential)) {
            return false;
        }
        HttpBearerCredential that = (HttpBearerCredential)o;
        return Objects.equals((Object)this.scheme(), (Object)that.scheme()) && Objects.equals(this.credential, that.credential);
    }

    public int hashCode() {
        return 31 * super.hashCode() * Objects.hash(new Object[]{this.scheme(), this.credential});
    }
}

