/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.KeyConstraintException;
import io.confluent.security.authentication.oauthbearer.SignatureAlgorithm;
import java.util.Set;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public final class AlgorithmWhitelist
implements Constraint {
    private final Set<SignatureAlgorithm> algorithmWhitelist;

    public AlgorithmWhitelist(Set<SignatureAlgorithm> algorithmWhitelist) {
        this.algorithmWhitelist = algorithmWhitelist;
    }

    @Override
    public void validate(JsonWebSignature jws) throws KeyConstraintException {
        try {
            String algorithm = jws.getHeader("alg");
            if (!this.algorithmWhitelist.contains((Object)SignatureAlgorithm.valueOf(algorithm))) {
                throw new KeyConstraintException("Invalid Signature Verification Key Algorithm " + algorithm);
            }
        }
        catch (JoseException e) {
            throw new KeyConstraintException("Unable to validate JWS signature verification key", e);
        }
    }
}

