/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.oauthbearer.Claims;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;

public class JwtPrincipal
implements Principal,
Claims {
    private static final long NOT_BEFORE_NULL = -1L;
    private static final long ISSUED_AT_NULL = -1L;
    private final String jti;
    private final String issuer;
    private final Set<String> audience;
    private final String subject;
    private final long notBefore;
    private final long issuedAt;
    private final long expiresOn;
    private final JwtClaims claims;

    public JwtPrincipal(JwtClaims claims) {
        try {
            this.jti = claims.getJwtId();
            this.issuer = claims.getIssuer();
            this.audience = new HashSet<String>(claims.getAudience());
            this.subject = claims.getSubject();
            NumericDate notBeforeDate = claims.getNotBefore();
            this.notBefore = notBeforeDate != null ? notBeforeDate.getValueInMillis() : -1L;
            NumericDate issuedAtDate = claims.getIssuedAt();
            this.issuedAt = issuedAtDate != null ? issuedAtDate.getValueInMillis() : -1L;
            this.expiresOn = claims.getExpirationTime().getValueInMillis();
        }
        catch (MalformedClaimException e) {
            throw new IllegalArgumentException("Unable to construct Principal", e);
        }
        this.claims = claims;
    }

    @Override
    public String getName() {
        return this.subject;
    }

    @Override
    public String jti() {
        return this.jti;
    }

    @Override
    public String issuer() {
        return this.issuer;
    }

    @Override
    public String subject() {
        return this.subject;
    }

    @Override
    public String authorizedParty() {
        return this.subject;
    }

    @Override
    public Set<String> audience() {
        return this.audience;
    }

    @Override
    public long notBefore() {
        return this.notBefore;
    }

    @Override
    public long issuedAt() {
        return this.issuedAt;
    }

    @Override
    public long expiresOn() {
        return this.expiresOn;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.claims.getClaimsMap();
    }

    @Override
    public <T> Collection<T> claimValues(String claim, Class<T> collectionType) {
        return this.toTypedCollection(this.claimValue(claim, List.class), collectionType);
    }

    @Override
    public <T> T claimValue(String claim, Class<T> valueType) {
        try {
            return (T)this.claims.getClaimValue(claim, valueType);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Claim value could not be extracted", t);
        }
    }

    private <T> Collection<T> toTypedCollection(List<?> list, Class<T> valueType) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<T> values = new ArrayList<T>();
        for (Object object : list) {
            try {
                values.add(valueType.cast(object));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Claim value could not be extracted", e);
            }
        }
        return values;
    }
}

