/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.api.events;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public class Event {
    public static final String APPLICATION_PROTOBUF = "application/protobuf";
    public static final String APPLICATION_X_PROTOBUF = "application/x-protobuf";
    public static final String APPLICATION_JSON = "application/json";
    private String type;
    private URI source;
    private String subject;
    private String id;
    private OffsetDateTime time;
    private String dataContentType;
    private URI dataSchema;
    private byte[] data;
    protected Map<String, String> extensions = new HashMap<String, String>();

    public String type() {
        return this.type;
    }

    public URI source() {
        return this.source;
    }

    public String subject() {
        return this.subject;
    }

    public String id() {
        return this.id;
    }

    public OffsetDateTime time() {
        return this.time;
    }

    public Optional<byte[]> data() {
        return Optional.ofNullable(this.data);
    }

    public String dataContentType() {
        return this.dataContentType;
    }

    public Optional<URI> dataSchema() {
        return Optional.ofNullable(this.dataSchema);
    }

    public String extension(String name) {
        return this.extensions.get(name);
    }

    public Set<String> extensionNames() {
        return this.extensions.keySet();
    }

    public Event setType(String type) {
        this.type = type;
        return this;
    }

    public Event setSource(String source) {
        this.source = URI.create(source);
        return this;
    }

    public Event setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Event setId(String id) {
        this.id = id;
        return this;
    }

    public Event setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public Event setData(String contentType, URI dataSchema, byte[] data) {
        Objects.requireNonNull(contentType, "ContentType must not be null.");
        Objects.requireNonNull(data, "Data must not be null.");
        this.dataContentType = contentType;
        this.dataSchema = dataSchema;
        this.data = data;
        return this;
    }

    public Event setData(String contentType, byte[] data) {
        return this.setData(contentType, null, data);
    }

    public Event setExtension(String name, String value) {
        Objects.requireNonNull(name, "Extension name must not be null.");
        Objects.requireNonNull(value, "Extension value must not be null.");
        if (!Event.isValidExtensionName(name)) {
            throw new RuntimeException("Invalid extension: " + name);
        }
        this.extensions.put(name, value);
        return this;
    }

    public static boolean isValidExtensionName(String name) {
        char[] chars;
        if (name.length() > 20) {
            return false;
        }
        for (char c : chars = name.toCharArray()) {
            if (Event.isValidChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public String toString() {
        return new StringJoiner(", ", Event.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("source=" + this.source).add("subject='" + this.subject + "'").add("id='" + this.id + "'").add("time=" + this.time).add("dataContentType='" + this.dataContentType + "'").add("dataSchema=" + this.dataSchema).add("extensions=" + this.extensions).toString();
    }
}

