/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.cloudevents.SpecVersion;
import io.cloudevents.v1.proto.CloudEvent;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.exporter.http.HttpExporter;
import io.confluent.telemetry.events.v0.EventServiceRequest;
import io.confluent.telemetry.events.v0.EventServiceResponse;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHttpExporter
extends HttpExporter<Event, EventServiceRequest, EventServiceResponse> {
    private static final Logger log = LoggerFactory.getLogger(EventHttpExporter.class);
    public static final String V1_EVENTS_ENDPOINT = "/v1/events";

    public EventHttpExporter() {
        this.requestConverter = events -> EventServiceRequest.newBuilder().addAllEvents(this.toProto((Collection<Event>)events)).build();
        this.responseDeserializer = bytes -> {
            try {
                return EventServiceResponse.parseFrom((ByteBuffer)bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        };
        this.endpoint = V1_EVENTS_ENDPOINT;
    }

    private CloudEvent.CloudEventAttributeValue toAttr(String str) {
        return CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(str).build();
    }

    private CloudEvent.CloudEventAttributeValue toAttr(OffsetDateTime time) {
        Instant instant = Instant.from(time);
        Timestamp timeProto = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        return CloudEvent.CloudEventAttributeValue.newBuilder().setCeTimestamp(timeProto).build();
    }

    private List<CloudEvent> toProto(Collection<Event> events) {
        return events.stream().map(e -> {
            CloudEvent.Builder ceProtoBuilder = CloudEvent.newBuilder().setId(e.id()).setSource(e.source().toString()).setSpecVersion(SpecVersion.V1.toString()).setType(e.type()).putAttributes("datacontenttype", this.toAttr(e.dataContentType())).putAttributes("subject", this.toAttr(e.subject())).putAttributes("time", this.toAttr(e.time())).putAttributes("dataschema", this.toAttr(e.dataSchema().toString()));
            for (String ext : e.extensionNames()) {
                ceProtoBuilder.putAttributes(ext, this.toAttr(e.extension(ext)));
            }
            if (e.data().isPresent()) {
                ceProtoBuilder.setBinaryData(ByteString.copyFrom((byte[])((byte[])e.data().get())));
            }
            return ceProtoBuilder.build();
        }).collect(Collectors.toList());
    }
}

