/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.kafka.KafkaMessageFactory;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.exporter.kafka.KafkaExporter;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventKafkaExporter
extends KafkaExporter<Event> {
    private static final Logger log = LoggerFactory.getLogger(EventKafkaExporter.class);
    private final EventFormat structuredEventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    public EventKafkaExporter() {
        this(KafkaProducer::new);
    }

    EventKafkaExporter(Function<Properties, Producer<String, byte[]>> producerFactory) {
        super(producerFactory);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.responseDeserializer = event -> {
            String topic = this.topicName;
            if (event.extensionNames().contains("route")) {
                topic = event.extension("route");
            }
            CloudEvent data = EventUtils.toCloudEvent(event);
            MessageWriter messageWriter = KafkaMessageFactory.createWriter((String)topic, (Object)event.extension("partitionkey"));
            switch (this.config.getEncoding()) {
                case STRUCTURED: {
                    return (ProducerRecord)messageWriter.writeStructured(data, this.structuredEventFormat);
                }
                case BINARY: {
                    return (ProducerRecord)messageWriter.writeBinary(data);
                }
            }
            throw new RuntimeException("Unknown encoding " + String.valueOf(this.config.getEncoding()));
        };
    }
}

