/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import io.confluent.telemetry.api.events.Event;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class EventRouteFilter
implements Predicate<Event> {
    private final Set<String> allowedRoutes;

    public EventRouteFilter(String ... allowedRoutes) {
        this(Arrays.asList(allowedRoutes));
    }

    public EventRouteFilter(Collection<String> allowedRoutes) {
        this.allowedRoutes = allowedRoutes == null ? Collections.emptySet() : new HashSet<String>(allowedRoutes);
    }

    @Override
    public boolean test(Event event) {
        if (this.allowedRoutes.isEmpty()) {
            return false;
        }
        return event.extensionNames().contains("route") && this.allowedRoutes.contains(event.extension("route"));
    }
}

