/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.formatter.AnsiEscapes;
import cucumber.runtime.formatter.Format;
import cucumber.runtime.formatter.Formats;
import java.util.HashMap;
import java.util.Map;

final class AnsiFormats
implements Formats {
    private static final Map<String, Format> formats = new HashMap<String, Format>(){
        {
            this.put("undefined", new ColorFormat(AnsiEscapes.YELLOW));
            this.put("undefined_arg", new ColorFormat(AnsiEscapes.YELLOW, AnsiEscapes.INTENSITY_BOLD));
            this.put("pending", new ColorFormat(AnsiEscapes.YELLOW));
            this.put("pending_arg", new ColorFormat(AnsiEscapes.YELLOW, AnsiEscapes.INTENSITY_BOLD));
            this.put("executing", new ColorFormat(AnsiEscapes.GREY));
            this.put("executing_arg", new ColorFormat(AnsiEscapes.GREY, AnsiEscapes.INTENSITY_BOLD));
            this.put("failed", new ColorFormat(AnsiEscapes.RED));
            this.put("failed_arg", new ColorFormat(AnsiEscapes.RED, AnsiEscapes.INTENSITY_BOLD));
            this.put("ambiguous", new ColorFormat(AnsiEscapes.RED));
            this.put("ambiguous_arg", new ColorFormat(AnsiEscapes.RED, AnsiEscapes.INTENSITY_BOLD));
            this.put("passed", new ColorFormat(AnsiEscapes.GREEN));
            this.put("passed_arg", new ColorFormat(AnsiEscapes.GREEN, AnsiEscapes.INTENSITY_BOLD));
            this.put("outline", new ColorFormat(AnsiEscapes.CYAN));
            this.put("outline_arg", new ColorFormat(AnsiEscapes.CYAN, AnsiEscapes.INTENSITY_BOLD));
            this.put("skipped", new ColorFormat(AnsiEscapes.CYAN));
            this.put("skipped_arg", new ColorFormat(AnsiEscapes.CYAN, AnsiEscapes.INTENSITY_BOLD));
            this.put("comment", new ColorFormat(AnsiEscapes.GREY));
            this.put("tag", new ColorFormat(AnsiEscapes.CYAN));
            this.put("output", new ColorFormat(AnsiEscapes.BLUE));
        }
    };

    AnsiFormats() {
    }

    @Override
    public Format get(String key) {
        Format format = formats.get(key);
        if (format == null) {
            throw new NullPointerException("No format for key " + key);
        }
        return format;
    }

    @Override
    public String up(int n) {
        return AnsiEscapes.up(n).toString();
    }

    private static final class ColorFormat
    implements Format {
        private final AnsiEscapes[] escapes;

        ColorFormat(AnsiEscapes ... escapes) {
            this.escapes = escapes;
        }

        @Override
        public String text(String text) {
            StringBuilder sb = new StringBuilder();
            for (AnsiEscapes escape : this.escapes) {
                escape.appendTo(sb);
            }
            sb.append(text);
            AnsiEscapes.RESET.appendTo(sb);
            return sb.toString();
        }
    }
}

