/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.RunnerSupplier;
import cucumber.runner.SingletonRunnerSupplier;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CompositeCucumberException;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ExitStatus;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import cucumber.runtime.order.PickleOrder;
import gherkin.events.PickleEvent;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.RuntimeOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Runtime {
    private static final Logger log = LoggerFactory.getLogger(Runtime.class);
    private final ExitStatus exitStatus;
    private final RunnerSupplier runnerSupplier;
    private final Filters filters;
    private final EventBus bus;
    private final FeatureSupplier featureSupplier;
    private final Plugins plugins;
    private final ExecutorService executor;
    private final PickleOrder pickleOrder;

    public Runtime(Plugins plugins, RuntimeOptions runtimeOptions, EventBus bus, Filters filters, RunnerSupplier runnerSupplier, FeatureSupplier featureSupplier, ExecutorService executor, PickleOrder pickleOrder) {
        this.plugins = plugins;
        this.filters = filters;
        this.bus = bus;
        this.runnerSupplier = runnerSupplier;
        this.featureSupplier = featureSupplier;
        this.executor = executor;
        this.exitStatus = new ExitStatus(runtimeOptions);
        this.pickleOrder = pickleOrder;
        this.exitStatus.setEventPublisher(bus);
    }

    public void run() {
        List<CucumberFeature> features = this.featureSupplier.get();
        this.bus.send(new TestRunStarted(this.bus.getTime(), (long)this.bus.getTimeMillis()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(this.bus);
        }
        StepDefinitionReporter stepDefinitionReporter = this.plugins.stepDefinitionReporter();
        this.runnerSupplier.get().reportStepDefinitions(stepDefinitionReporter);
        ArrayList<PickleEvent> filteredEvents = new ArrayList<PickleEvent>();
        for (CucumberFeature feature : features) {
            for (PickleEvent pickleEvent : feature.getPickles()) {
                if (!this.filters.matchesFilters(pickleEvent)) continue;
                filteredEvents.add(pickleEvent);
            }
        }
        List<PickleEvent> orderedEvents = this.pickleOrder.orderPickleEvents(filteredEvents);
        List<PickleEvent> limitedEvents = this.filters.limitPickleEvents(orderedEvents);
        ArrayList executingPickles = new ArrayList();
        for (final PickleEvent pickleEvent : limitedEvents) {
            executingPickles.add(this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Runtime.this.runnerSupplier.get().runPickle(pickleEvent);
                }
            }));
        }
        this.executor.shutdown();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (Future future : executingPickles) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                log.error("Exception while executing pickle", e);
                arrayList.add(e.getCause());
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                throw new CucumberException(e);
            }
        }
        if (arrayList.size() == 1) {
            throw new CucumberException((Throwable)arrayList.get(0));
        }
        if (arrayList.size() > 1) {
            throw new CompositeCucumberException(arrayList);
        }
        this.bus.send(new TestRunFinished(this.bus.getTime(), (long)this.bus.getTimeMillis()));
    }

    public byte exitStatus() {
        return this.exitStatus.exitStatus();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class SameThreadExecutorService
    extends AbstractExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }

    private static final class CucumberThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "cucumber-runner-" + poolNumber.getAndIncrement() + "-thread-";

        CucumberThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
        }
    }

    public static class Builder {
        private EventBus eventBus = new TimeServiceEventBus(TimeService.SYSTEM);
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private RuntimeOptions runtimeOptions = RuntimeOptions.defaultOptions();
        private BackendSupplier backendSupplier;
        private ResourceLoader resourceLoader;
        private ClassFinder classFinder;
        private FeatureSupplier featureSupplier;
        private List<Plugin> additionalPlugins = Collections.emptyList();

        private Builder() {
        }

        public Builder withRuntimeOptions(RuntimeOptions runtimeOptions) {
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
            return this;
        }

        public Builder withClassFinder(ClassFinder classFinder) {
            this.classFinder = classFinder;
            return this;
        }

        public Builder withBackendSupplier(BackendSupplier backendSupplier) {
            this.backendSupplier = backendSupplier;
            return this;
        }

        public Builder withFeatureSupplier(FeatureSupplier featureSupplier) {
            this.featureSupplier = featureSupplier;
            return this;
        }

        public Builder withAdditionalPlugins(Plugin ... plugins) {
            this.additionalPlugins = Arrays.asList(plugins);
            return this;
        }

        public Builder withEventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Runtime build() {
            ResourceLoader resourceLoader = this.resourceLoader != null ? this.resourceLoader : new MultiLoader(this.classLoader);
            ClassFinder classFinder = this.classFinder != null ? this.classFinder : new ResourceLoaderClassFinder(resourceLoader, this.classLoader);
            BackendSupplier backendSupplier = this.backendSupplier != null ? this.backendSupplier : new BackendModuleBackendSupplier(resourceLoader, classFinder, this.runtimeOptions);
            Plugins plugins = new Plugins(this.classLoader, new PluginFactory(), this.runtimeOptions);
            for (Plugin plugin : this.additionalPlugins) {
                plugins.addPlugin(plugin);
            }
            if (this.runtimeOptions.isMultiThreaded()) {
                plugins.setSerialEventBusOnEventListenerPlugins(this.eventBus);
            } else {
                plugins.setEventBusOnEventListenerPlugins(this.eventBus);
            }
            RunnerSupplier runnerSupplier = this.runtimeOptions.isMultiThreaded() ? new ThreadLocalRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier) : new SingletonRunnerSupplier(this.runtimeOptions, this.eventBus, backendSupplier);
            SameThreadExecutorService executor = this.runtimeOptions.isMultiThreaded() ? Executors.newFixedThreadPool(this.runtimeOptions.getThreads(), new CucumberThreadFactory()) : new SameThreadExecutorService();
            FeatureLoader featureLoader = new FeatureLoader(resourceLoader);
            FeatureSupplier featureSupplier = this.featureSupplier != null ? this.featureSupplier : new FeaturePathFeatureSupplier(featureLoader, this.runtimeOptions);
            Filters filters = new Filters(this.runtimeOptions);
            PickleOrder pickleOrder = this.runtimeOptions.getPickleOrder();
            return new Runtime(plugins, this.runtimeOptions, this.eventBus, filters, runnerSupplier, featureSupplier, executor, pickleOrder);
        }
    }
}

