/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.filter;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class TagPredicate
implements Predicate<Pickle> {
    private final List<Expression> expressions = new ArrayList<Expression>();

    TagPredicate(String tagExpression) {
        this(tagExpression.isEmpty() ? Collections.emptyList() : Collections.singletonList(tagExpression));
    }

    TagPredicate(List<String> tagExpressions) {
        if (tagExpressions == null) {
            return;
        }
        TagExpressionParser parser = new TagExpressionParser();
        for (String tagExpression : tagExpressions) {
            this.expressions.add(parser.parse(tagExpression));
        }
    }

    @Override
    public boolean test(Pickle pickle) {
        if (this.expressions.isEmpty()) {
            return true;
        }
        List tags = pickle.getTags();
        return this.expressions.stream().allMatch(expression -> expression.evaluate(tags));
    }
}

