/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.CanonicalOrderEventPublisher;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.StrictAware;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import java.util.ArrayList;
import java.util.List;

public final class Plugins {
    private final List<Plugin> plugins;
    private boolean pluginNamesInstantiated;
    private final PluginFactory pluginFactory;
    private EventPublisher orderedEventPublisher;
    private final Options pluginOptions;

    public Plugins(PluginFactory pluginFactory, Options pluginOptions) {
        this.pluginFactory = pluginFactory;
        this.pluginOptions = pluginOptions;
        this.plugins = this.createPlugins();
    }

    private EventPublisher getOrderedEventPublisher(EventPublisher eventPublisher) {
        if (this.orderedEventPublisher == null) {
            this.orderedEventPublisher = Plugins.createCanonicalOrderEventPublisher(eventPublisher);
        }
        return this.orderedEventPublisher;
    }

    private static EventPublisher createCanonicalOrderEventPublisher(EventPublisher eventPublisher) {
        CanonicalOrderEventPublisher canonicalOrderEventPublisher = new CanonicalOrderEventPublisher();
        eventPublisher.registerHandlerFor(Event.class, canonicalOrderEventPublisher::handle);
        return canonicalOrderEventPublisher;
    }

    private List<Plugin> createPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (!this.pluginNamesInstantiated) {
            for (Options.Plugin pluginOption : this.pluginOptions.plugins()) {
                Plugin plugin = this.pluginFactory.create(pluginOption);
                this.addPlugin(plugins, plugin);
            }
            this.pluginNamesInstantiated = true;
        }
        return plugins;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void addPlugin(Plugin plugin) {
        this.addPlugin(this.plugins, plugin);
    }

    private void addPlugin(List<Plugin> plugins, Plugin plugin) {
        plugins.add(plugin);
        this.setMonochromeOnColorAwarePlugins(plugin);
        this.setStrictOnStrictAwarePlugins(plugin);
    }

    private void setMonochromeOnColorAwarePlugins(Plugin plugin) {
        if (plugin instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)plugin;
            colorAware.setMonochrome(this.pluginOptions.isMonochrome());
        }
    }

    private void setStrictOnStrictAwarePlugins(Plugin plugin) {
        if (plugin instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)plugin;
            strictAware.setStrict(this.pluginOptions.isStrict());
        }
    }

    public void setEventBusOnEventListenerPlugins(EventPublisher eventPublisher) {
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof ConcurrentEventListener) {
                ((ConcurrentEventListener)plugin).setEventPublisher(eventPublisher);
                continue;
            }
            if (!(plugin instanceof EventListener)) continue;
            ((EventListener)plugin).setEventPublisher(eventPublisher);
        }
    }

    public void setSerialEventBusOnEventListenerPlugins(EventPublisher eventPublisher) {
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof ConcurrentEventListener) {
                ((ConcurrentEventListener)plugin).setEventPublisher(eventPublisher);
                continue;
            }
            if (!(plugin instanceof EventListener)) continue;
            EventPublisher orderedEventPublisher = this.getOrderedEventPublisher(eventPublisher);
            ((EventListener)plugin).setEventPublisher(orderedEventPublisher);
        }
    }
}

