/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.htmlformatter.MessagesToHtmlWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class HtmlFormatter
implements ConcurrentEventListener {
    private final MessagesToHtmlWriter writer;

    public HtmlFormatter(OutputStream out) throws IOException {
        this.writer = new MessagesToHtmlWriter((Writer)new UTF8OutputStreamWriter(out));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        if (event.getStepDefinition() != null || event.getHook() != null || event.getParameterType() != null) {
            return;
        }
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished() != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

