/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.AnsiEscapes;

interface Format {
    public String text(String var1);

    public static Format color(AnsiEscapes ... escapes) {
        return new Color(escapes);
    }

    public static Format monochrome() {
        return new Monochrome();
    }

    public static final class Color
    implements Format {
        private final AnsiEscapes[] escapes;

        private Color(AnsiEscapes ... escapes) {
            this.escapes = escapes;
        }

        @Override
        public String text(String text) {
            StringBuilder sb = new StringBuilder();
            for (AnsiEscapes escape : this.escapes) {
                escape.appendTo(sb);
            }
            sb.append(text);
            if (this.escapes.length > 0) {
                AnsiEscapes.RESET.appendTo(sb);
            }
            return sb.toString();
        }
    }

    public static class Monochrome
    implements Format {
        private Monochrome() {
        }

        @Override
        public String text(String text) {
            return text;
        }
    }
}

