/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.AbstractDatatableElementTransformerDefinition;
import io.cucumber.java.DataTableType;
import io.cucumber.java.InvalidMethodSignatureException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class JavaDataTableTypeDefinition
extends AbstractDatatableElementTransformerDefinition
implements DataTableTypeDefinition {
    private final io.cucumber.datatable.DataTableType dataTableType;

    JavaDataTableTypeDefinition(Method method, Lookup lookup, String[] emptyPatterns) {
        super(method, lookup, emptyPatterns);
        this.dataTableType = this.createDataTableType(method);
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DataTableType.class).addSignature("public Author author(DataTable table)").addSignature("public Author author(List<String> row)").addSignature("public Author author(Map<String, String> entry)").addSignature("public Author author(String cell)").addNote("Note: Author is an example of the class you want to convert the table to.").build();
    }

    private static Type requireValidParameterType(Method method) {
        Type[] typeParameters;
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            throw JavaDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        Type parameterType = parameterTypes[0];
        if (!(parameterType instanceof ParameterizedType)) {
            return parameterType;
        }
        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
        for (Type typeParameter : typeParameters = parameterizedType.getActualTypeArguments()) {
            if (String.class.equals((Object)typeParameter)) continue;
            throw JavaDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        return parameterizedType.getRawType();
    }

    private static Type requireValidReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (Void.class.equals((Object)returnType) || Void.TYPE.equals(returnType)) {
            throw JavaDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        return returnType;
    }

    private io.cucumber.datatable.DataTableType createDataTableType(Method method) {
        Type returnType = JavaDataTableTypeDefinition.requireValidReturnType(method);
        Type parameterType = JavaDataTableTypeDefinition.requireValidParameterType(method);
        if (DataTable.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, table -> this.invokeMethod(this.replaceEmptyPatternsWithEmptyString(table)));
        }
        if (List.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, row -> this.invokeMethod(this.replaceEmptyPatternsWithEmptyString(row)));
        }
        if (Map.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, entry -> this.invokeMethod(this.replaceEmptyPatternsWithEmptyString(entry)));
        }
        if (String.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, cell -> this.invokeMethod(this.replaceEmptyPatternsWithEmptyString(cell)));
        }
        throw JavaDataTableTypeDefinition.createInvalidSignatureException(method);
    }

    public io.cucumber.datatable.DataTableType dataTableType() {
        return this.dataTableType;
    }
}

