/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.io.ClassFinder;
import io.cucumber.core.io.MultiLoader;
import io.cucumber.core.io.ResourceLoader;
import io.cucumber.core.io.ResourceLoaderClassFinder;
import io.cucumber.java8.Java8Snippet;
import io.cucumber.java8.LambdaGlue;
import io.cucumber.java8.LambdaGlueRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

final class Java8Backend
implements Backend {
    private final Lookup lookup;
    private final Container container;
    private final ClassFinder classFinder;
    private final List<Class<? extends LambdaGlue>> lambdaGlueClasses = new ArrayList<Class<? extends LambdaGlue>>();
    private Glue glue;

    Java8Backend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderProvider) {
        this.container = container;
        this.lookup = lookup;
        ClassLoader classLoader = classLoaderProvider.get();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        this.glue = glue;
        gluePaths.stream().map(packageName -> this.classFinder.getDescendants(LambdaGlue.class, packageName)).flatMap(Collection::stream).filter(glueClass -> !glueClass.isInterface()).filter(glueClass -> glueClass.getConstructors().length > 0).forEach(glueClass -> {
            if (this.container.addClass(glueClass)) {
                this.lambdaGlueClasses.add((Class<? extends LambdaGlue>)glueClass);
            }
        });
    }

    public void buildWorld() {
        LambdaGlueRegistry.INSTANCE.set(new GlueAdaptor(this.glue));
        for (Class<? extends LambdaGlue> lambdaGlueClass : this.lambdaGlueClasses) {
            this.lookup.getInstance(lambdaGlueClass);
        }
    }

    public void disposeWorld() {
        LambdaGlueRegistry.INSTANCE.remove();
    }

    public Snippet getSnippet() {
        return new Java8Snippet();
    }

    private static final class GlueAdaptor
    implements LambdaGlueRegistry {
        private final Glue glue;

        private GlueAdaptor(Glue glue) {
            this.glue = glue;
        }

        @Override
        public void addStepDefinition(StepDefinition stepDefinition) {
            this.glue.addStepDefinition(stepDefinition);
        }

        @Override
        public void addBeforeStepHookDefinition(HookDefinition beforeStepHook) {
            this.glue.addBeforeStepHook(beforeStepHook);
        }

        @Override
        public void addAfterStepHookDefinition(HookDefinition afterStepHook) {
            this.glue.addAfterStepHook(afterStepHook);
        }

        @Override
        public void addBeforeHookDefinition(HookDefinition beforeHook) {
            this.glue.addBeforeHook(beforeHook);
        }

        @Override
        public void addAfterHookDefinition(HookDefinition afterHook) {
            this.glue.addAfterHook(afterHook);
        }

        @Override
        public void addDocStringType(DocStringTypeDefinition docStringTypeDefinition) {
            this.glue.addDocStringType(docStringTypeDefinition);
        }

        @Override
        public void addDataTableType(DataTableTypeDefinition dataTableTypeDefinition) {
            this.glue.addDataTableType(dataTableTypeDefinition);
        }

        @Override
        public void addParameterType(ParameterTypeDefinition parameterTypeDefinition) {
            this.glue.addParameterType(parameterTypeDefinition);
        }
    }
}

