/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.PluginFactory;
import io.cucumber.core.plugin.Plugins;
import io.cucumber.core.runtime.BackendServiceLoader;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.ObjectFactoryServiceLoader;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.ScanningTypeRegistryConfigurerSupplier;
import io.cucumber.core.runtime.SingletonObjectFactorySupplier;
import io.cucumber.core.runtime.SingletonRunnerSupplier;
import io.cucumber.core.runtime.SynchronizedEventBus;
import io.cucumber.core.runtime.ThreadLocalObjectFactorySupplier;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.runtime.TypeRegistryConfigurerSupplier;
import io.cucumber.junit.platform.engine.CucumberEngineOptions;
import io.cucumber.junit.platform.engine.TestCaseResultObserver;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import java.time.Clock;
import java.util.UUID;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;

@API(status=API.Status.STABLE)
public final class CucumberEngineExecutionContext
implements EngineExecutionContext {
    private static final Logger log = LoggerFactory.getLogger(CucumberEngineExecutionContext.class);
    private final CucumberEngineOptions options;
    private final CucumberExecutionContext context;

    CucumberEngineExecutionContext(ConfigurationParameters configurationParameters) {
        ThreadLocalRunnerSupplier runnerSupplier;
        Supplier<ClassLoader> classLoader = CucumberEngineExecutionContext.class::getClassLoader;
        log.debug(() -> "Parsing options");
        this.options = new CucumberEngineOptions(configurationParameters);
        ObjectFactoryServiceLoader objectFactoryServiceLoader = new ObjectFactoryServiceLoader((io.cucumber.core.backend.Options)this.options);
        SynchronizedEventBus bus = SynchronizedEventBus.synchronize((EventBus)new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID));
        ScanningTypeRegistryConfigurerSupplier typeRegistryConfigurerSupplier = new ScanningTypeRegistryConfigurerSupplier(classLoader, (io.cucumber.core.runner.Options)this.options);
        Plugins plugins = new Plugins(new PluginFactory(), (Options)this.options);
        ExitStatus exitStatus = new ExitStatus((Options)this.options);
        plugins.addPlugin((Plugin)exitStatus);
        if (this.options.isParallelExecutionEnabled()) {
            plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)bus);
            ThreadLocalObjectFactorySupplier objectFactorySupplier = new ThreadLocalObjectFactorySupplier(objectFactoryServiceLoader);
            BackendServiceLoader backendSupplier = new BackendServiceLoader(classLoader, (ObjectFactorySupplier)objectFactorySupplier);
            runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.runner.Options)this.options, (EventBus)bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        } else {
            plugins.setEventBusOnEventListenerPlugins((EventPublisher)bus);
            SingletonObjectFactorySupplier objectFactorySupplier = new SingletonObjectFactorySupplier(objectFactoryServiceLoader);
            BackendServiceLoader backendSupplier = new BackendServiceLoader(classLoader, (ObjectFactorySupplier)objectFactorySupplier);
            runnerSupplier = new SingletonRunnerSupplier((io.cucumber.core.runner.Options)this.options, (EventBus)bus, (BackendSupplier)backendSupplier, (ObjectFactorySupplier)objectFactorySupplier, (TypeRegistryConfigurerSupplier)typeRegistryConfigurerSupplier);
        }
        this.context = new CucumberExecutionContext((EventBus)bus, exitStatus, (RunnerSupplier)runnerSupplier);
    }

    CucumberEngineOptions getOptions() {
        return this.options;
    }

    void startTestRun() {
        this.context.startTestRun();
    }

    public void beforeFeature(Feature feature) {
        this.context.beforeFeature(feature);
    }

    void runTestCase(Pickle pickle) {
        this.context.runTestCase(runner -> {
            try (TestCaseResultObserver observer = TestCaseResultObserver.observe(runner.getBus());){
                log.debug(() -> "Executing test case " + pickle.getName());
                runner.runPickle(pickle);
                log.debug(() -> "Finished test case " + pickle.getName());
                observer.assertTestCasePassed();
            }
        });
    }

    public void finishTestRun() {
        this.context.finishTestRun();
    }
}

