/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableDiff;
import io.cucumber.datatable.DiffType;
import io.cucumber.datatable.DiffableRow;
import io.cucumber.datatable.dependency.difflib.Delta;
import io.cucumber.datatable.dependency.difflib.DiffUtils;
import io.cucumber.datatable.dependency.difflib.Patch;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class TableDiffer {
    private final DataTable from;
    private final DataTable to;

    public TableDiffer(DataTable fromTable, DataTable toTable) {
        this.checkColumns(fromTable, toTable);
        this.from = fromTable;
        this.to = toTable;
    }

    private void checkColumns(DataTable a, DataTable b) {
        if (a.width() != b.width() && !b.isEmpty()) {
            throw new IllegalArgumentException("Tables must have equal number of columns:\n" + a + "\n" + b);
        }
    }

    public DataTableDiff calculateDiffs() {
        Map<Integer, Delta> deltasByLine = this.createDeltasByLine();
        return this.createTableDiff(deltasByLine);
    }

    public DataTableDiff calculateUnorderedDiffs() {
        ArrayList<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows = new ArrayList<AbstractMap.SimpleEntry<List<String>, DiffType>>();
        ArrayList<List<String>> extraRows = new ArrayList<List<String>>(this.to.cells());
        for (List<String> row : this.from.cells()) {
            if (!extraRows.remove(row)) {
                diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(row, DiffType.DELETE));
                continue;
            }
            diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(row, DiffType.NONE));
        }
        for (List<String> cells : extraRows) {
            diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(cells, DiffType.INSERT));
        }
        return DataTableDiff.create(diffTableRows);
    }

    private static List<DiffableRow> getDiffableRows(DataTable raw) {
        ArrayList<DiffableRow> result = new ArrayList<DiffableRow>();
        for (List<String> row : raw.cells()) {
            result.add(new DiffableRow(row, row));
        }
        return result;
    }

    private Map<Integer, Delta> createDeltasByLine() {
        Patch patch = DiffUtils.diff(TableDiffer.getDiffableRows(this.from), TableDiffer.getDiffableRows(this.to));
        List deltas = patch.getDeltas();
        HashMap<Integer, Delta> deltasByLine = new HashMap<Integer, Delta>();
        for (Delta delta : deltas) {
            deltasByLine.put(delta.getOriginal().getPosition(), delta);
        }
        return deltasByLine;
    }

    private DataTableDiff createTableDiff(Map<Integer, Delta> deltasByLine) {
        ArrayList<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows = new ArrayList<AbstractMap.SimpleEntry<List<String>, DiffType>>();
        List<List<String>> rows = this.from.cells();
        for (int i = 0; i < rows.size(); ++i) {
            Delta delta = deltasByLine.get(i);
            if (delta == null) {
                diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(this.from.row(i), DiffType.NONE));
                continue;
            }
            this.addRowsToTableDiff(diffTableRows, delta);
            if (delta.getType() == Delta.TYPE.CHANGE || delta.getType() == Delta.TYPE.DELETE) {
                i += delta.getOriginal().getLines().size() - 1;
                continue;
            }
            diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(this.from.row(i), DiffType.NONE));
        }
        Delta remainingDelta = deltasByLine.get(rows.size());
        if (remainingDelta != null) {
            this.addRowsToTableDiff(diffTableRows, remainingDelta);
        }
        return DataTableDiff.create(diffTableRows);
    }

    private void addRowsToTableDiff(List<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows, Delta delta) {
        this.markChangedAndDeletedRowsInOriginalAsMissing(diffTableRows, delta);
        this.markChangedAndInsertedRowsInRevisedAsNew(diffTableRows, delta);
    }

    private void markChangedAndDeletedRowsInOriginalAsMissing(List<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows, Delta delta) {
        List deletedLines = delta.getOriginal().getLines();
        for (DiffableRow row : deletedLines) {
            diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(row.row, DiffType.DELETE));
        }
    }

    private void markChangedAndInsertedRowsInRevisedAsNew(List<AbstractMap.SimpleEntry<List<String>, DiffType>> diffTableRows, Delta delta) {
        List insertedLines = delta.getRevised().getLines();
        for (DiffableRow row : insertedLines) {
            diffTableRows.add(new AbstractMap.SimpleEntry<List<String>, DiffType>(row.row, DiffType.INSERT));
        }
    }
}

