/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.InvalidDataTableTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class TypeFactory {
    private TypeFactory() {
    }

    static JavaType aListOf(Type type) {
        return new ListType(null, List.class, TypeFactory.constructType(type));
    }

    static JavaType constructType(Type type) {
        try {
            return TypeFactory.constructTypeInner(type);
        }
        catch (Exception e) {
            throw new InvalidDataTableTypeException(type, e);
        }
    }

    private static JavaType constructTypeInner(Type type) {
        if (type instanceof JavaType) {
            return (JavaType)type;
        }
        if (List.class.equals((Object)type)) {
            return new ListType(type, List.class, TypeFactory.constructType(Object.class));
        }
        if (Map.class.equals((Object)type)) {
            return new MapType(type, Map.class, TypeFactory.constructType(Object.class), TypeFactory.constructType(Object.class));
        }
        if (type instanceof Class) {
            return new OtherType(type);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("Type contained a type variable " + type + ". Types must explicit.");
        }
        if (type instanceof WildcardType) {
            return TypeFactory.constructWildCardType((WildcardType)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeFactory.constructParameterizedType((ParameterizedType)type);
        }
        return new OtherType(type);
    }

    private static JavaType constructWildCardType(WildcardType type) {
        Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length > 0) {
            if (upperBounds.length > 1) {
                throw new IllegalArgumentException("Type contained more then upper lower bound " + type + ". Types may only have a single upper bound.");
            }
            return TypeFactory.constructType(upperBounds[0]);
        }
        return new OtherType(type);
    }

    private static JavaType constructParameterizedType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        JavaType[] deconstructedTypeArguments = TypeFactory.deConstructTypeArguments(type);
        if (List.class.equals((Object)rawType)) {
            return new ListType(type, List.class, deconstructedTypeArguments[0]);
        }
        if (Map.class.equals((Object)rawType)) {
            return new MapType(type, Map.class, deconstructedTypeArguments[0], deconstructedTypeArguments[1]);
        }
        return new Parameterized(type, rawType, deconstructedTypeArguments);
    }

    private static JavaType[] deConstructTypeArguments(ParameterizedType type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        JavaType[] deconstructedTypeArguments = new JavaType[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            deconstructedTypeArguments[i] = TypeFactory.constructTypeInner(actualTypeArguments[i]);
        }
        return deconstructedTypeArguments;
    }

    static String typeName(Type type) {
        return type.getTypeName();
    }

    static final class MapType
    implements JavaType {
        private final Type original;
        private final Class<?> rawClass;
        private final JavaType keyType;
        private final JavaType valueType;

        MapType(Type original, Class<?> rawClass, JavaType keyType, JavaType valueType) {
            this.original = original;
            this.rawClass = rawClass;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapType mapType = (MapType)o;
            return this.rawClass.equals(mapType.rawClass) && this.keyType.equals(mapType.keyType) && this.valueType.equals(mapType.valueType);
        }

        public int hashCode() {
            return Objects.hash(this.rawClass, this.keyType, this.valueType);
        }

        @Override
        public String getTypeName() {
            return this.original.getTypeName();
        }

        JavaType getKeyType() {
            return this.keyType;
        }

        JavaType getValueType() {
            return this.valueType;
        }

        @Override
        public Type getOriginal() {
            return this.original;
        }
    }

    static final class ListType
    implements JavaType {
        private final Type original;
        private final Class<?> rawClass;
        private final JavaType elementType;

        ListType(Type original, Class<?> rawClass, JavaType elementType) {
            this.original = original;
            this.rawClass = rawClass;
            this.elementType = elementType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListType listType = (ListType)o;
            return this.rawClass.equals(listType.rawClass) && this.elementType.equals(listType.elementType);
        }

        public int hashCode() {
            return Objects.hash(this.rawClass, this.elementType);
        }

        @Override
        public String getTypeName() {
            if (this.original != null) {
                return this.original.getTypeName();
            }
            return this.rawClass.getTypeName() + "<" + this.elementType.getTypeName() + ">";
        }

        JavaType getElementType() {
            return this.elementType;
        }

        @Override
        public Type getOriginal() {
            return this.original;
        }
    }

    static class Parameterized
    implements JavaType {
        private final Type original;
        private final Class<?> rawClass;
        private final JavaType[] elementTypes;

        private Parameterized(Type original, Class<?> rawClass, JavaType[] elementTypes) {
            this.original = original;
            this.rawClass = rawClass;
            this.elementTypes = elementTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameterized that = (Parameterized)o;
            return this.rawClass.equals(that.rawClass) && Arrays.equals(this.elementTypes, that.elementTypes);
        }

        JavaType[] getElementTypes() {
            return this.elementTypes;
        }

        public int hashCode() {
            int result = Objects.hash(this.rawClass);
            result = 31 * result + Arrays.hashCode(this.elementTypes);
            return result;
        }

        @Override
        public Type getOriginal() {
            return this.original;
        }

        @Override
        public String getTypeName() {
            return this.original.getTypeName();
        }
    }

    static final class OtherType
    implements JavaType {
        private final Type original;

        OtherType(Type original) {
            this.original = original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OtherType otherType = (OtherType)o;
            return this.original.equals(otherType.original);
        }

        public int hashCode() {
            return Objects.hash(this.original);
        }

        @Override
        public String getTypeName() {
            return this.original.getTypeName();
        }

        @Override
        public Type getOriginal() {
            return this.original;
        }
    }

    static interface JavaType
    extends Type {
        public Type getOriginal();
    }
}

