/*
 * Decompiled with CFR 0.152.
 */
package gherkin.pickles;

import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.SymbolCounter;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Compiler {
    public List<Pickle> compile(Feature feature, String path) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        GherkinDialect dialect = new GherkinDialectProvider().getDialect(feature.getLanguage(), null);
        List<Tag> featureTags = feature.getTags();
        List<PickleStep> backgroundSteps = this.getBackgroundSteps(feature.getBackground(), path);
        for (ScenarioDefinition scenarioDefinition : feature.getScenarioDefinitions()) {
            if (scenarioDefinition instanceof Scenario) {
                this.compileScenario(pickles, backgroundSteps, (Scenario)scenarioDefinition, featureTags, path);
                continue;
            }
            this.compileScenarioOutline(pickles, backgroundSteps, (ScenarioOutline)scenarioDefinition, featureTags, path, dialect);
        }
        return pickles;
    }

    private void compileScenario(List<Pickle> pickles, List<PickleStep> backgroundSteps, Scenario scenario, List<Tag> featureTags, String path) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        steps.addAll(backgroundSteps);
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(featureTags);
        scenarioTags.addAll(scenario.getTags());
        for (Step step : scenario.getSteps()) {
            steps.add(this.pickleStep(step, path));
        }
        Pickle pickle = new Pickle(scenario.getKeyword() + ": " + scenario.getName(), steps, this.pickleTags(scenarioTags, path), Collections.singletonList(this.pickleLocation(scenario.getLocation(), path)));
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, List<PickleStep> backgroundSteps, ScenarioOutline scenarioOutline, List<Tag> featureTags, String path, GherkinDialect dialect) {
        String keyword = dialect.getScenarioKeywords().get(0);
        for (Examples examples : scenarioOutline.getExamples()) {
            List<TableCell> variableCells = examples.getTableHeader().getCells();
            for (TableRow values : examples.getTableBody()) {
                List<TableCell> valueCells = values.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                steps.addAll(backgroundSteps);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenarioOutline.getTags());
                tags.addAll(examples.getTags());
                for (Step scenarioOutlineStep : scenarioOutline.getSteps()) {
                    String stepText = this.interpolate(scenarioOutlineStep.getText(), variableCells, valueCells);
                    PickleStep pickleStep = new PickleStep(stepText, this.createPickleArguments(scenarioOutlineStep.getArgument(), variableCells, valueCells, path), Arrays.asList(this.pickleLocation(values.getLocation(), path), this.pickleStepLocation(scenarioOutlineStep, path)));
                    steps.add(pickleStep);
                }
                Pickle pickle = new Pickle(keyword + ": " + this.interpolate(scenarioOutline.getName(), variableCells, valueCells), steps, this.pickleTags(tags, path), Arrays.asList(this.pickleLocation(values.getLocation(), path), this.pickleLocation(scenarioOutline.getLocation(), path)));
                pickles.add(pickle);
            }
        }
    }

    private List<Argument> createPickleArguments(Node argument, String path) {
        List<TableCell> noCells = Collections.emptyList();
        return this.createPickleArguments(argument, noCells, noCells, path);
    }

    private List<Argument> createPickleArguments(Node argument, List<TableCell> variableCells, List<TableCell> valueCells, String path) {
        ArrayList<Argument> result = new ArrayList<Argument>();
        if (argument == null) {
            return result;
        }
        if (argument instanceof DataTable) {
            DataTable t = (DataTable)argument;
            List<TableRow> rows = t.getRows();
            ArrayList<PickleRow> newRows = new ArrayList<PickleRow>(rows.size());
            for (TableRow row : rows) {
                List<TableCell> cells = row.getCells();
                ArrayList<PickleCell> newCells = new ArrayList<PickleCell>();
                for (TableCell cell : cells) {
                    newCells.add(new PickleCell(this.pickleLocation(cell.getLocation(), path), this.interpolate(cell.getValue(), variableCells, valueCells)));
                }
                newRows.add(new PickleRow(newCells));
            }
            result.add(new PickleTable(newRows));
        } else if (argument instanceof DocString) {
            DocString ds = (DocString)argument;
            result.add(new PickleString(this.pickleLocation(ds.getLocation(), path), this.interpolate(ds.getContent(), variableCells, valueCells)));
        } else {
            throw new RuntimeException("Unexpected argument type: " + argument);
        }
        return result;
    }

    private List<PickleStep> getBackgroundSteps(Background background, String path) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        if (background != null) {
            for (Step step : background.getSteps()) {
                result.add(this.pickleStep(step, path));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private PickleStep pickleStep(Step step, String path) {
        return new PickleStep(step.getText(), this.createPickleArguments(step.getArgument(), path), Collections.singletonList(this.pickleStepLocation(step, path)));
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private PickleLocation pickleStepLocation(Step step, String path) {
        return new PickleLocation(path, step.getLocation().getLine(), step.getLocation().getColumn() + (step.getKeyword() != null ? SymbolCounter.countSymbols(step.getKeyword()) : 0));
    }

    private PickleLocation pickleLocation(Location location, String path) {
        return new PickleLocation(path, location.getLine(), location.getColumn());
    }

    private List<PickleTag> pickleTags(List<Tag> tags, String path) {
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag, path));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag, String path) {
        return new PickleTag(this.pickleLocation(tag.getLocation(), path), tag.getName());
    }
}

