package io.cucumber.gherkin;

import java.util.Objects;

import static io.cucumber.messages.types.StepKeywordType.ACTION;
import static io.cucumber.messages.types.StepKeywordType.CONJUNCTION;
import static io.cucumber.messages.types.StepKeywordType.CONTEXT;
import static io.cucumber.messages.types.StepKeywordType.OUTCOME;
import static io.cucumber.messages.types.StepKeywordType.UNKNOWN;

import static io.cucumber.gherkin.Constants.TITLE_KEYWORD_SEPARATOR_LENGTH;

/**
* Generated by GenerateKeywordMatchers.
*/
final class KeywordMatchers {

    static KeywordMatcher of(String language) {
        Objects.requireNonNull(language);
        switch (language){
            case "af":
                return new Af();
            case "am":
                return new Am();
            case "amh":
                return new Amh();
            case "an":
                return new An();
            case "ar":
                return new Ar();
            case "ast":
                return new Ast();
            case "az":
                return new Az();
            case "be":
                return new Be();
            case "bg":
                return new Bg();
            case "bm":
                return new Bm();
            case "bs":
                return new Bs();
            case "ca":
                return new Ca();
            case "cs":
                return new Cs();
            case "cy-GB":
                return new Cy_gb();
            case "da":
                return new Da();
            case "de":
                return new De();
            case "el":
                return new El();
            case "em":
                return new Em();
            case "en":
                return new En();
            case "en-Scouse":
                return new En_scouse();
            case "en-au":
                return new En_au();
            case "en-lol":
                return new En_lol();
            case "en-old":
                return new En_old();
            case "en-pirate":
                return new En_pirate();
            case "en-tx":
                return new En_tx();
            case "eo":
                return new Eo();
            case "es":
                return new Es();
            case "et":
                return new Et();
            case "fa":
                return new Fa();
            case "fi":
                return new Fi();
            case "fr":
                return new Fr();
            case "ga":
                return new Ga();
            case "gj":
                return new Gj();
            case "gl":
                return new Gl();
            case "he":
                return new He();
            case "hi":
                return new Hi();
            case "hr":
                return new Hr();
            case "ht":
                return new Ht();
            case "hu":
                return new Hu();
            case "id":
                return new Id();
            case "is":
                return new Is();
            case "it":
                return new It();
            case "ja":
                return new Ja();
            case "jv":
                return new Jv();
            case "ka":
                return new Ka();
            case "kn":
                return new Kn();
            case "ko":
                return new Ko();
            case "lt":
                return new Lt();
            case "lu":
                return new Lu();
            case "lv":
                return new Lv();
            case "mk-Cyrl":
                return new Mk_cyrl();
            case "mk-Latn":
                return new Mk_latn();
            case "ml":
                return new Ml();
            case "mn":
                return new Mn();
            case "mr":
                return new Mr();
            case "ne":
                return new Ne();
            case "nl":
                return new Nl();
            case "no":
                return new No();
            case "pa":
                return new Pa();
            case "pl":
                return new Pl();
            case "pt":
                return new Pt();
            case "ro":
                return new Ro();
            case "ru":
                return new Ru();
            case "sk":
                return new Sk();
            case "sl":
                return new Sl();
            case "sr-Cyrl":
                return new Sr_cyrl();
            case "sr-Latn":
                return new Sr_latn();
            case "sv":
                return new Sv();
            case "ta":
                return new Ta();
            case "te":
                return new Te();
            case "th":
                return new Th();
            case "tlh":
                return new Tlh();
            case "tr":
                return new Tr();
            case "tt":
                return new Tt();
            case "uk":
                return new Uk();
            case "ur":
                return new Ur();
            case "uz":
                return new Uz();
            case "vi":
                return new Vi();
            case "zh-CN":
                return new Zh_cn();
            case "zh-TW":
                return new Zh_tw();
            default:
                return null;
        }
    }
    private static final class Af implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Besigheid Behoefte")) {
                return new Match("Besigheid Behoefte", 18 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funksie")) {
                return new Match("Funksie", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Vermoë")) {
                return new Match("Vermoë", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Agtergrond")) {
                return new Match("Agtergrond", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reël")) {
                return new Match("Reël", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Reel")) {
                return new Match("Reel", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Situasie Uiteensetting")) {
                return new Match("Situasie Uiteensetting", 22  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Voorbeeld")) {
                return new Match("Voorbeeld", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Situasie")) {
                return new Match("Situasie", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voorbeelde")) {
                return new Match("Voorbeelde", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Wanneer ")) {
                return new StepMatch("Wanneer ", 8, ACTION );
            }
            if (line.startsWith("Gegewe ")) {
                return new StepMatch("Gegewe ", 7, CONTEXT );
            }
            if (line.startsWith("Maar ")) {
                return new StepMatch("Maar ", 5, CONJUNCTION );
            }
            if (line.startsWith("Dan ")) {
                return new StepMatch("Dan ", 4, OUTCOME );
            }
            if (line.startsWith("En ")) {
                return new StepMatch("En ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Am implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ֆունկցիոնալություն")) {
                return new Match("Ֆունկցիոնալություն", 18 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Հատկություն")) {
                return new Match("Հատկություն", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Կոնտեքստ")) {
                return new Match("Կոնտեքստ", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Սցենարի կառուցվացքը")) {
                return new Match("Սցենարի կառուցվացքը", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Օրինակ")) {
                return new Match("Օրինակ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Սցենար")) {
                return new Match("Սցենար", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Օրինակներ")) {
                return new Match("Օրինակներ", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Դիցուք ")) {
                return new StepMatch("Դիցուք ", 7, CONTEXT );
            }
            if (line.startsWith("Բայց ")) {
                return new StepMatch("Բայց ", 5, CONJUNCTION );
            }
            if (line.startsWith("Ապա ")) {
                return new StepMatch("Ապա ", 4, OUTCOME );
            }
            if (line.startsWith("Երբ ")) {
                return new StepMatch("Երբ ", 4, ACTION );
            }
            if (line.startsWith("Եթե ")) {
                return new StepMatch("Եթե ", 4, ACTION );
            }
            if (line.startsWith("Եվ ")) {
                return new StepMatch("Եվ ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Amh implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("የሚፈለገው ድርጊት")) {
                return new Match("የሚፈለገው ድርጊት", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("የተፈለገው ስራ")) {
                return new Match("የተፈለገው ስራ", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ስራ")) {
                return new Match("ስራ", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("መነሻ ሀሳብ")) {
                return new Match("መነሻ ሀሳብ", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ቅድመ ሁኔታ")) {
                return new Match("ቅድመ ሁኔታ", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("መነሻ")) {
                return new Match("መነሻ", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ህግ")) {
                return new Match("ህግ", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("ሁናቴ ዝርዝር")) {
                return new Match("ሁናቴ ዝርዝር", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ሁናቴ አብነት")) {
                return new Match("ሁናቴ አብነት", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ሁናቴ")) {
                return new Match("ሁናቴ", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ምሳሌ")) {
                return new Match("ምሳሌ", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ምሳሌዎች")) {
                return new Match("ምሳሌዎች", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ሁናቴዎች")) {
                return new Match("ሁናቴዎች", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("የተሰጠ ")) {
                return new StepMatch("የተሰጠ ", 5, CONTEXT );
            }
            if (line.startsWith("ከዚያ ")) {
                return new StepMatch("ከዚያ ", 4, OUTCOME );
            }
            if (line.startsWith("ግን ")) {
                return new StepMatch("ግን ", 3, CONJUNCTION );
            }
            if (line.startsWith("መቼ ")) {
                return new StepMatch("መቼ ", 3, ACTION );
            }
            if (line.startsWith("እና ")) {
                return new StepMatch("እና ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class An implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Caracteristica")) {
                return new Match("Caracteristica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedents")) {
                return new Match("Antecedents", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema del caso")) {
                return new Match("Esquema del caso", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Eixemplo")) {
                return new Match("Eixemplo", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Caso")) {
                return new Match("Caso", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eixemplos")) {
                return new Match("Eixemplos", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Antonces ")) {
                return new StepMatch("Antonces ", 9, OUTCOME );
            }
            if (line.startsWith("Alavez ")) {
                return new StepMatch("Alavez ", 7, OUTCOME );
            }
            if (line.startsWith("Allora ")) {
                return new StepMatch("Allora ", 7, OUTCOME );
            }
            if (line.startsWith("Dadas ")) {
                return new StepMatch("Dadas ", 6, CONTEXT );
            }
            if (line.startsWith("Cuan ")) {
                return new StepMatch("Cuan ", 5, ACTION );
            }
            if (line.startsWith("Daus ")) {
                return new StepMatch("Daus ", 5, CONTEXT );
            }
            if (line.startsWith("Dada ")) {
                return new StepMatch("Dada ", 5, CONTEXT );
            }
            if (line.startsWith("Pero ")) {
                return new StepMatch("Pero ", 5, CONJUNCTION );
            }
            if (line.startsWith("Dau ")) {
                return new StepMatch("Dau ", 4, CONTEXT );
            }
            if (line.startsWith("Y ")) {
                return new StepMatch("Y ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ar implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("خاصية")) {
                return new Match("خاصية", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("الخلفية")) {
                return new Match("الخلفية", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("سيناريو مخطط")) {
                return new Match("سيناريو مخطط", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("سيناريو")) {
                return new Match("سيناريو", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("مثال")) {
                return new Match("مثال", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("امثلة")) {
                return new Match("امثلة", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("عندما ")) {
                return new StepMatch("عندما ", 6, ACTION );
            }
            if (line.startsWith("اذاً ")) {
                return new StepMatch("اذاً ", 5, OUTCOME );
            }
            if (line.startsWith("بفرض ")) {
                return new StepMatch("بفرض ", 5, CONTEXT );
            }
            if (line.startsWith("لكن ")) {
                return new StepMatch("لكن ", 4, CONJUNCTION );
            }
            if (line.startsWith("متى ")) {
                return new StepMatch("متى ", 4, ACTION );
            }
            if (line.startsWith("ثم ")) {
                return new StepMatch("ثم ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("و ")) {
                return new StepMatch("و ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ast implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Carauterística")) {
                return new Match("Carauterística", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedentes")) {
                return new Match("Antecedentes", 12 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esbozu del casu")) {
                return new Match("Esbozu del casu", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new Match("Exemplo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Casu")) {
                return new Match("Casu", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new Match("Exemplos", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Cuando ")) {
                return new StepMatch("Cuando ", 7, ACTION );
            }
            if (line.startsWith("Entós ")) {
                return new StepMatch("Entós ", 6, OUTCOME );
            }
            if (line.startsWith("Dada ")) {
                return new StepMatch("Dada ", 5, CONTEXT );
            }
            if (line.startsWith("Daos ")) {
                return new StepMatch("Daos ", 5, CONTEXT );
            }
            if (line.startsWith("Daes ")) {
                return new StepMatch("Daes ", 5, CONTEXT );
            }
            if (line.startsWith("Peru ")) {
                return new StepMatch("Peru ", 5, CONJUNCTION );
            }
            if (line.startsWith("Dáu ")) {
                return new StepMatch("Dáu ", 4, CONTEXT );
            }
            if (line.startsWith("Ya ")) {
                return new StepMatch("Ya ", 3, CONJUNCTION );
            }
            if (line.startsWith("Y ")) {
                return new StepMatch("Y ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Az implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Özəllik")) {
                return new Match("Özəllik", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new Match("Kontekst", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Keçmiş")) {
                return new Match("Keçmiş", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ssenarinin strukturu")) {
                return new Match("Ssenarinin strukturu", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ssenari")) {
                return new Match("Ssenari", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Nümunə")) {
                return new Match("Nümunə", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Nümunələr")) {
                return new Match("Nümunələr", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Nə vaxt ki ")) {
                return new StepMatch("Nə vaxt ki ", 11, ACTION );
            }
            if (line.startsWith("Tutaq ki ")) {
                return new StepMatch("Tutaq ki ", 9, CONTEXT );
            }
            if (line.startsWith("O halda ")) {
                return new StepMatch("O halda ", 8, OUTCOME );
            }
            if (line.startsWith("Verilir ")) {
                return new StepMatch("Verilir ", 8, CONTEXT );
            }
            if (line.startsWith("Ancaq ")) {
                return new StepMatch("Ancaq ", 6, CONJUNCTION );
            }
            if (line.startsWith("Əgər ")) {
                return new StepMatch("Əgər ", 5, ACTION );
            }
            if (line.startsWith("Amma ")) {
                return new StepMatch("Amma ", 5, CONJUNCTION );
            }
            if (line.startsWith("Həm ")) {
                return new StepMatch("Həm ", 4, CONJUNCTION );
            }
            if (line.startsWith("Və ")) {
                return new StepMatch("Və ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Be implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функцыянальнасць")) {
                return new Match("Функцыянальнасць", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Фіча")) {
                return new Match("Фіча", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Кантэкст")) {
                return new Match("Кантэкст", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Правілы")) {
                return new Match("Правілы", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Шаблон сцэнарыя")) {
                return new Match("Шаблон сцэнарыя", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Узор сцэнара")) {
                return new Match("Узор сцэнара", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сцэнарый")) {
                return new Match("Сцэнарый", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cцэнар")) {
                return new Match("Cцэнар", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Прыклады")) {
                return new Match("Прыклады", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Таксама ")) {
                return new StepMatch("Таксама ", 8, CONJUNCTION );
            }
            if (line.startsWith("Дадзена ")) {
                return new StepMatch("Дадзена ", 8, CONTEXT );
            }
            if (line.startsWith("Інакш ")) {
                return new StepMatch("Інакш ", 6, CONJUNCTION );
            }
            if (line.startsWith("Няхай ")) {
                return new StepMatch("Няхай ", 6, CONTEXT );
            }
            if (line.startsWith("Калі ")) {
                return new StepMatch("Калі ", 5, ACTION );
            }
            if (line.startsWith("Тады ")) {
                return new StepMatch("Тады ", 5, OUTCOME );
            }
            if (line.startsWith("Але ")) {
                return new StepMatch("Але ", 4, CONJUNCTION );
            }
            if (line.startsWith("Ды ")) {
                return new StepMatch("Ды ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Bg implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функционалност")) {
                return new Match("Функционалност", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Предистория")) {
                return new Match("Предистория", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Правило")) {
                return new Match("Правило", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Рамка на сценарий")) {
                return new Match("Рамка на сценарий", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарий")) {
                return new Match("Сценарий", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Пример")) {
                return new Match("Пример", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Примери")) {
                return new Match("Примери", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Когато ")) {
                return new StepMatch("Когато ", 7, ACTION );
            }
            if (line.startsWith("Дадено ")) {
                return new StepMatch("Дадено ", 7, CONTEXT );
            }
            if (line.startsWith("Но ")) {
                return new StepMatch("Но ", 3, CONJUNCTION );
            }
            if (line.startsWith("То ")) {
                return new StepMatch("То ", 3, OUTCOME );
            }
            if (line.startsWith("И ")) {
                return new StepMatch("И ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Bm implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fungsi")) {
                return new Match("Fungsi", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Latar Belakang")) {
                return new Match("Latar Belakang", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Garis Panduan Senario")) {
                return new Match("Garis Panduan Senario", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kerangka Senario")) {
                return new Match("Kerangka Senario", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kerangka Keadaan")) {
                return new Match("Kerangka Keadaan", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kerangka Situasi")) {
                return new Match("Kerangka Situasi", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Keadaan")) {
                return new Match("Keadaan", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Senario")) {
                return new Match("Senario", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Situasi")) {
                return new Match("Situasi", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contoh")) {
                return new Match("Contoh", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Kemudian ")) {
                return new StepMatch("Kemudian ", 9, OUTCOME );
            }
            if (line.startsWith("Apabila ")) {
                return new StepMatch("Apabila ", 8, ACTION );
            }
            if (line.startsWith("Diberi ")) {
                return new StepMatch("Diberi ", 7, CONTEXT );
            }
            if (line.startsWith("Tetapi ")) {
                return new StepMatch("Tetapi ", 7, CONJUNCTION );
            }
            if (line.startsWith("Bagi ")) {
                return new StepMatch("Bagi ", 5, CONTEXT );
            }
            if (line.startsWith("Tapi ")) {
                return new StepMatch("Tapi ", 5, CONJUNCTION );
            }
            if (line.startsWith("Maka ")) {
                return new StepMatch("Maka ", 5, OUTCOME );
            }
            if (line.startsWith("Dan ")) {
                return new StepMatch("Dan ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Bs implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Karakteristika")) {
                return new Match("Karakteristika", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new Match("Pozadina", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario-outline")) {
                return new Match("Scenario-outline", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariju-obris")) {
                return new Match("Scenariju-obris", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariju")) {
                return new Match("Scenariju", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primjer")) {
                return new Match("Primjer", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Primjeri")) {
                return new Match("Primjeri", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Zatim ")) {
                return new StepMatch("Zatim ", 6, OUTCOME );
            }
            if (line.startsWith("Kada ")) {
                return new StepMatch("Kada ", 5, ACTION );
            }
            if (line.startsWith("Dato ")) {
                return new StepMatch("Dato ", 5, CONTEXT );
            }
            if (line.startsWith("Ali ")) {
                return new StepMatch("Ali ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            if (line.startsWith("A ")) {
                return new StepMatch("A ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ca implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Característica")) {
                return new Match("Característica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funcionalitat")) {
                return new Match("Funcionalitat", 13 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedents")) {
                return new Match("Antecedents", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Rerefons")) {
                return new Match("Rerefons", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema de l'escenari")) {
                return new Match("Esquema de l'escenari", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Escenari")) {
                return new Match("Escenari", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemple")) {
                return new Match("Exemple", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemples")) {
                return new Match("Exemples", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Aleshores ")) {
                return new StepMatch("Aleshores ", 10, OUTCOME );
            }
            if (line.startsWith("Donada ")) {
                return new StepMatch("Donada ", 7, CONTEXT );
            }
            if (line.startsWith("Donat ")) {
                return new StepMatch("Donat ", 6, CONTEXT );
            }
            if (line.startsWith("Atesa ")) {
                return new StepMatch("Atesa ", 6, CONTEXT );
            }
            if (line.startsWith("Quan ")) {
                return new StepMatch("Quan ", 5, ACTION );
            }
            if (line.startsWith("Atès ")) {
                return new StepMatch("Atès ", 5, CONTEXT );
            }
            if (line.startsWith("Però ")) {
                return new StepMatch("Però ", 5, CONJUNCTION );
            }
            if (line.startsWith("Cal ")) {
                return new StepMatch("Cal ", 4, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Cs implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Požadavek")) {
                return new Match("Požadavek", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontext")) {
                return new Match("Kontext", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Pozadí")) {
                return new Match("Pozadí", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pravidlo")) {
                return new Match("Pravidlo", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Osnova scénáře")) {
                return new Match("Osnova scénáře", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Náčrt Scénáře")) {
                return new Match("Náčrt Scénáře", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Příklad")) {
                return new Match("Příklad", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scénář")) {
                return new Match("Scénář", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Příklady")) {
                return new Match("Příklady", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za předpokladu ")) {
                return new StepMatch("Za předpokladu ", 15, CONTEXT );
            }
            if (line.startsWith("A také ")) {
                return new StepMatch("A také ", 7, CONJUNCTION );
            }
            if (line.startsWith("Pokud ")) {
                return new StepMatch("Pokud ", 6, CONTEXT );
            }
            if (line.startsWith("Když ")) {
                return new StepMatch("Když ", 5, ACTION );
            }
            if (line.startsWith("Pak ")) {
                return new StepMatch("Pak ", 4, OUTCOME );
            }
            if (line.startsWith("Ale ")) {
                return new StepMatch("Ale ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("A ")) {
                return new StepMatch("A ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Cy_gb implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Arwedd")) {
                return new Match("Arwedd", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cefndir")) {
                return new Match("Cefndir", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario Amlinellol")) {
                return new Match("Scenario Amlinellol", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Enghraifft")) {
                return new Match("Enghraifft", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Enghreifftiau")) {
                return new Match("Enghreifftiau", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Anrhegedig a ")) {
                return new StepMatch("Anrhegedig a ", 13, CONTEXT );
            }
            if (line.startsWith("Pryd ")) {
                return new StepMatch("Pryd ", 5, ACTION );
            }
            if (line.startsWith("Yna ")) {
                return new StepMatch("Yna ", 4, OUTCOME );
            }
            if (line.startsWith("Ond ")) {
                return new StepMatch("Ond ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("A ")) {
                return new StepMatch("A ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Da implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskab")) {
                return new Match("Egenskab", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Baggrund")) {
                return new Match("Baggrund", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new Match("Regel", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new Match("Abstrakt Scenario", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Eksempel")) {
                return new Match("Eksempel", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenarie")) {
                return new Match("Scenarie", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eksempler")) {
                return new Match("Eksempler", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Givet ")) {
                return new StepMatch("Givet ", 6, CONTEXT );
            }
            if (line.startsWith("Når ")) {
                return new StepMatch("Når ", 4, ACTION );
            }
            if (line.startsWith("Men ")) {
                return new StepMatch("Men ", 4, CONJUNCTION );
            }
            if (line.startsWith("Og ")) {
                return new StepMatch("Og ", 3, CONJUNCTION );
            }
            if (line.startsWith("Så ")) {
                return new StepMatch("Så ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class De implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funktionalität")) {
                return new Match("Funktionalität", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funktion")) {
                return new Match("Funktion", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voraussetzungen")) {
                return new Match("Voraussetzungen", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Vorbedingungen")) {
                return new Match("Vorbedingungen", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Hintergrund")) {
                return new Match("Hintergrund", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Grundlage")) {
                return new Match("Grundlage", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new Match("Regel", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szenariogrundriss")) {
                return new Match("Szenariogrundriss", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Szenarien")) {
                return new Match("Szenarien", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Szenario")) {
                return new Match("Szenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Beispiel")) {
                return new Match("Beispiel", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Beispiele")) {
                return new Match("Beispiele", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Gegeben seien ")) {
                return new StepMatch("Gegeben seien ", 14, CONTEXT );
            }
            if (line.startsWith("Gegeben sei ")) {
                return new StepMatch("Gegeben sei ", 12, CONTEXT );
            }
            if (line.startsWith("Angenommen ")) {
                return new StepMatch("Angenommen ", 11, CONTEXT );
            }
            if (line.startsWith("Wenn ")) {
                return new StepMatch("Wenn ", 5, ACTION );
            }
            if (line.startsWith("Dann ")) {
                return new StepMatch("Dann ", 5, OUTCOME );
            }
            if (line.startsWith("Aber ")) {
                return new StepMatch("Aber ", 5, CONJUNCTION );
            }
            if (line.startsWith("Und ")) {
                return new StepMatch("Und ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class El implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Δυνατότητα")) {
                return new Match("Δυνατότητα", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Λειτουργία")) {
                return new Match("Λειτουργία", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Υπόβαθρο")) {
                return new Match("Υπόβαθρο", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Περίγραμμα Σεναρίου")) {
                return new Match("Περίγραμμα Σεναρίου", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Περιγραφή Σεναρίου")) {
                return new Match("Περιγραφή Σεναρίου", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Παράδειγμα")) {
                return new Match("Παράδειγμα", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Σενάριο")) {
                return new Match("Σενάριο", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Παραδείγματα")) {
                return new Match("Παραδείγματα", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Σενάρια")) {
                return new Match("Σενάρια", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Δεδομένου ")) {
                return new StepMatch("Δεδομένου ", 10, CONTEXT );
            }
            if (line.startsWith("Όταν ")) {
                return new StepMatch("Όταν ", 5, ACTION );
            }
            if (line.startsWith("Αλλά ")) {
                return new StepMatch("Αλλά ", 5, CONJUNCTION );
            }
            if (line.startsWith("Τότε ")) {
                return new StepMatch("Τότε ", 5, OUTCOME );
            }
            if (line.startsWith("Και ")) {
                return new StepMatch("Και ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Em implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("📚")) {
                return new Match("📚", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("💤")) {
                return new Match("💤", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("📖")) {
                return new Match("📖", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("📕")) {
                return new Match("📕", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("🥒")) {
                return new Match("🥒", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("📓")) {
                return new Match("📓", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("😐")) {
                return new StepMatch("😐", 2, CONTEXT );
            }
            if (line.startsWith("🙏")) {
                return new StepMatch("🙏", 2, OUTCOME );
            }
            if (line.startsWith("🎬")) {
                return new StepMatch("🎬", 2, ACTION );
            }
            if (line.startsWith("😔")) {
                return new StepMatch("😔", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("😂")) {
                return new StepMatch("😂", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class En implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Business Need")) {
                return new Match("Business Need", 13 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ability")) {
                return new Match("Ability", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Feature")) {
                return new Match("Feature", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Background")) {
                return new Match("Background", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenario Template")) {
                return new Match("Scenario Template", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario Outline")) {
                return new Match("Scenario Outline", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Example")) {
                return new Match("Example", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarios")) {
                return new Match("Scenarios", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Examples")) {
                return new Match("Examples", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Given ")) {
                return new StepMatch("Given ", 6, CONTEXT );
            }
            if (line.startsWith("Then ")) {
                return new StepMatch("Then ", 5, OUTCOME );
            }
            if (line.startsWith("When ")) {
                return new StepMatch("When ", 5, ACTION );
            }
            if (line.startsWith("But ")) {
                return new StepMatch("But ", 4, CONJUNCTION );
            }
            if (line.startsWith("And ")) {
                return new StepMatch("And ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_scouse implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Feature")) {
                return new Match("Feature", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dis is what went down")) {
                return new Match("Dis is what went down", 21 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("The thing of it is")) {
                return new Match("The thing of it is", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Wharrimean is")) {
                return new Match("Wharrimean is", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Examples")) {
                return new Match("Examples", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Youse know when youse got ")) {
                return new StepMatch("Youse know when youse got ", 26, CONTEXT );
            }
            if (line.startsWith("Youse know like when ")) {
                return new StepMatch("Youse know like when ", 21, ACTION );
            }
            if (line.startsWith("Den youse gotta ")) {
                return new StepMatch("Den youse gotta ", 16, OUTCOME );
            }
            if (line.startsWith("Givun ")) {
                return new StepMatch("Givun ", 6, CONTEXT );
            }
            if (line.startsWith("Dun ")) {
                return new StepMatch("Dun ", 4, OUTCOME );
            }
            if (line.startsWith("Buh ")) {
                return new StepMatch("Buh ", 4, CONJUNCTION );
            }
            if (line.startsWith("Wun ")) {
                return new StepMatch("Wun ", 4, ACTION );
            }
            if (line.startsWith("An ")) {
                return new StepMatch("An ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_au implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pretty much")) {
                return new Match("Pretty much", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("First off")) {
                return new Match("First off", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reckon it's like")) {
                return new Match("Reckon it's like", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Awww, look mate")) {
                return new Match("Awww, look mate", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("You'll wanna")) {
                return new Match("You'll wanna", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("But at the end of the day I reckon ")) {
                return new StepMatch("But at the end of the day I reckon ", 35, OUTCOME );
            }
            if (line.startsWith("It's just unbelievable ")) {
                return new StepMatch("It's just unbelievable ", 23, ACTION );
            }
            if (line.startsWith("Too right ")) {
                return new StepMatch("Too right ", 10, CONJUNCTION );
            }
            if (line.startsWith("Yeah nah ")) {
                return new StepMatch("Yeah nah ", 9, CONJUNCTION );
            }
            if (line.startsWith("Y'know ")) {
                return new StepMatch("Y'know ", 7, CONTEXT );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_lol implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("OH HAI")) {
                return new Match("OH HAI", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("B4")) {
                return new Match("B4", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("MISHUN SRSLY")) {
                return new Match("MISHUN SRSLY", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("MISHUN")) {
                return new Match("MISHUN", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("EXAMPLZ")) {
                return new Match("EXAMPLZ", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("I CAN HAZ ")) {
                return new StepMatch("I CAN HAZ ", 10, CONTEXT );
            }
            if (line.startsWith("BUT ")) {
                return new StepMatch("BUT ", 4, CONJUNCTION );
            }
            if (line.startsWith("WEN ")) {
                return new StepMatch("WEN ", 4, ACTION );
            }
            if (line.startsWith("DEN ")) {
                return new StepMatch("DEN ", 4, OUTCOME );
            }
            if (line.startsWith("AN ")) {
                return new StepMatch("AN ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_old implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Hwaet")) {
                return new Match("Hwaet", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Hwæt")) {
                return new Match("Hwæt", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Aer")) {
                return new Match("Aer", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ær")) {
                return new Match("Ær", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Swa hwaer swa")) {
                return new Match("Swa hwaer swa", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Swa hwær swa")) {
                return new Match("Swa hwær swa", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Swa")) {
                return new Match("Swa", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Se the")) {
                return new Match("Se the", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Se ðe")) {
                return new Match("Se ðe", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Se þe")) {
                return new Match("Se þe", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Bæþsealfa ")) {
                return new StepMatch("Bæþsealfa ", 10, ACTION );
            }
            if (line.startsWith("Bæþsealfe ")) {
                return new StepMatch("Bæþsealfe ", 10, ACTION );
            }
            if (line.startsWith("Ciricæwa ")) {
                return new StepMatch("Ciricæwa ", 9, ACTION );
            }
            if (line.startsWith("Ciricæwe ")) {
                return new StepMatch("Ciricæwe ", 9, ACTION );
            }
            if (line.startsWith("Bæþsealf ")) {
                return new StepMatch("Bæþsealf ", 9, ACTION );
            }
            if (line.startsWith("Tha the ")) {
                return new StepMatch("Tha the ", 8, OUTCOME );
            }
            if (line.startsWith("Ciricæw ")) {
                return new StepMatch("Ciricæw ", 8, ACTION );
            }
            if (line.startsWith("Þa þe ")) {
                return new StepMatch("Þa þe ", 6, OUTCOME );
            }
            if (line.startsWith("Ða ðe ")) {
                return new StepMatch("Ða ðe ", 6, OUTCOME );
            }
            if (line.startsWith("Thurh ")) {
                return new StepMatch("Thurh ", 6, CONTEXT );
            }
            if (line.startsWith("Ðurh ")) {
                return new StepMatch("Ðurh ", 5, CONTEXT );
            }
            if (line.startsWith("Þurh ")) {
                return new StepMatch("Þurh ", 5, CONTEXT );
            }
            if (line.startsWith("Tha ")) {
                return new StepMatch("Tha ", 4, OUTCOME );
            }
            if (line.startsWith("Ond ")) {
                return new StepMatch("Ond ", 4, CONJUNCTION );
            }
            if (line.startsWith("Ða ")) {
                return new StepMatch("Ða ", 3, OUTCOME );
            }
            if (line.startsWith("Þa ")) {
                return new StepMatch("Þa ", 3, OUTCOME );
            }
            if (line.startsWith("Ac ")) {
                return new StepMatch("Ac ", 3, CONJUNCTION );
            }
            if (line.startsWith("7 ")) {
                return new StepMatch("7 ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_pirate implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ahoy matey!")) {
                return new Match("Ahoy matey!", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Yo-ho-ho")) {
                return new Match("Yo-ho-ho", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Shiver me timbers")) {
                return new Match("Shiver me timbers", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Heave to")) {
                return new Match("Heave to", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dead men tell no tales")) {
                return new Match("Dead men tell no tales", 22  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Let go and haul ")) {
                return new StepMatch("Let go and haul ", 16, OUTCOME );
            }
            if (line.startsWith("Gangway! ")) {
                return new StepMatch("Gangway! ", 9, CONTEXT );
            }
            if (line.startsWith("Blimey! ")) {
                return new StepMatch("Blimey! ", 8, ACTION );
            }
            if (line.startsWith("Avast! ")) {
                return new StepMatch("Avast! ", 7, CONJUNCTION );
            }
            if (line.startsWith("Aye ")) {
                return new StepMatch("Aye ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class En_tx implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("This ain’t my first rodeo")) {
                return new Match("This ain’t my first rodeo", 25 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("All gussied up")) {
                return new Match("All gussied up", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Lemme tell y'all a story")) {
                return new Match("Lemme tell y'all a story", 24 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule ")) {
                return new Match("Rule ", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Busy as a hound in flea season")) {
                return new Match("Busy as a hound in flea season", 30  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Serious as a snake bite")) {
                return new Match("Serious as a snake bite", 23  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("All hat and no cattle")) {
                return new Match("All hat and no cattle", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Now that's a story longer than a cattle drive in July")) {
                return new Match("Now that's a story longer than a cattle drive in July", 53  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("There’s no tree but bears some fruit ")) {
                return new StepMatch("There’s no tree but bears some fruit ", 37, OUTCOME );
            }
            if (line.startsWith("Well now hold on, I'll you what ")) {
                return new StepMatch("Well now hold on, I'll you what ", 32, CONJUNCTION );
            }
            if (line.startsWith("Come hell or high water ")) {
                return new StepMatch("Come hell or high water ", 24, CONJUNCTION );
            }
            if (line.startsWith("Quick out of the chute ")) {
                return new StepMatch("Quick out of the chute ", 23, ACTION );
            }
            if (line.startsWith("All git out ")) {
                return new StepMatch("All git out ", 12, CONTEXT );
            }
            if (line.startsWith("Fixin' to ")) {
                return new StepMatch("Fixin' to ", 10, CONTEXT );
            }
            return null;
        }
    }
    private static final class Eo implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Trajto")) {
                return new Match("Trajto", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fono")) {
                return new Match("Fono", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regulo")) {
                return new Match("Regulo", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konturo de la scenaro")) {
                return new Match("Konturo de la scenaro", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kazo-skizo")) {
                return new Match("Kazo-skizo", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ekzemplo")) {
                return new Match("Ekzemplo", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenaro")) {
                return new Match("Scenaro", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skizo")) {
                return new Match("Skizo", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kazo")) {
                return new Match("Kazo", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ekzemploj")) {
                return new Match("Ekzemploj", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Donitaĵo ")) {
                return new StepMatch("Donitaĵo ", 9, CONTEXT );
            }
            if (line.startsWith("Komence ")) {
                return new StepMatch("Komence ", 8, CONTEXT );
            }
            if (line.startsWith("Sed ")) {
                return new StepMatch("Sed ", 4, CONJUNCTION );
            }
            if (line.startsWith("Kaj ")) {
                return new StepMatch("Kaj ", 4, CONJUNCTION );
            }
            if (line.startsWith("Se ")) {
                return new StepMatch("Se ", 3, ACTION );
            }
            if (line.startsWith("Do ")) {
                return new StepMatch("Do ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Es implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Necesidad del negocio")) {
                return new Match("Necesidad del negocio", 21 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Característica")) {
                return new Match("Característica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Requisito")) {
                return new Match("Requisito", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Antecedentes")) {
                return new Match("Antecedentes", 12 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regla de negocio")) {
                return new Match("Regla de negocio", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Regla")) {
                return new Match("Regla", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esquema del escenario")) {
                return new Match("Esquema del escenario", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Escenario")) {
                return new Match("Escenario", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ejemplo")) {
                return new Match("Ejemplo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ejemplos")) {
                return new Match("Ejemplos", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Entonces ")) {
                return new StepMatch("Entonces ", 9, OUTCOME );
            }
            if (line.startsWith("Cuando ")) {
                return new StepMatch("Cuando ", 7, ACTION );
            }
            if (line.startsWith("Dadas ")) {
                return new StepMatch("Dadas ", 6, CONTEXT );
            }
            if (line.startsWith("Dados ")) {
                return new StepMatch("Dados ", 6, CONTEXT );
            }
            if (line.startsWith("Dada ")) {
                return new StepMatch("Dada ", 5, CONTEXT );
            }
            if (line.startsWith("Dado ")) {
                return new StepMatch("Dado ", 5, CONTEXT );
            }
            if (line.startsWith("Pero ")) {
                return new StepMatch("Pero ", 5, CONJUNCTION );
            }
            if (line.startsWith("Y ")) {
                return new StepMatch("Y ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Et implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Omadus")) {
                return new Match("Omadus", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Taust")) {
                return new Match("Taust", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reegel")) {
                return new Match("Reegel", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Raamstsenaarium")) {
                return new Match("Raamstsenaarium", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Stsenaarium")) {
                return new Match("Stsenaarium", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Raamjuhtum")) {
                return new Match("Raamjuhtum", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Juhtum")) {
                return new Match("Juhtum", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Juhtumid")) {
                return new Match("Juhtumid", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Eeldades ")) {
                return new StepMatch("Eeldades ", 9, CONTEXT );
            }
            if (line.startsWith("Siis ")) {
                return new StepMatch("Siis ", 5, OUTCOME );
            }
            if (line.startsWith("Kuid ")) {
                return new StepMatch("Kuid ", 5, CONJUNCTION );
            }
            if (line.startsWith("Kui ")) {
                return new StepMatch("Kui ", 4, ACTION );
            }
            if (line.startsWith("Ja ")) {
                return new StepMatch("Ja ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Fa implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("وِیژگی")) {
                return new Match("وِیژگی", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("زمینه")) {
                return new Match("زمینه", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("الگوی سناریو")) {
                return new Match("الگوی سناریو", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("سناریو")) {
                return new Match("سناریو", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("مثال")) {
                return new Match("مثال", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("نمونه ها")) {
                return new Match("نمونه ها", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("با فرض ")) {
                return new StepMatch("با فرض ", 7, CONTEXT );
            }
            if (line.startsWith("هنگامی ")) {
                return new StepMatch("هنگامی ", 7, ACTION );
            }
            if (line.startsWith("آنگاه ")) {
                return new StepMatch("آنگاه ", 6, OUTCOME );
            }
            if (line.startsWith("اما ")) {
                return new StepMatch("اما ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("و ")) {
                return new StepMatch("و ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Fi implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Ominaisuus")) {
                return new Match("Ominaisuus", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tausta")) {
                return new Match("Tausta", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tapausaihio")) {
                return new Match("Tapausaihio", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Tapaus")) {
                return new Match("Tapaus", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tapaukset")) {
                return new Match("Tapaukset", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Oletetaan ")) {
                return new StepMatch("Oletetaan ", 10, CONTEXT );
            }
            if (line.startsWith("Mutta ")) {
                return new StepMatch("Mutta ", 6, CONJUNCTION );
            }
            if (line.startsWith("Niin ")) {
                return new StepMatch("Niin ", 5, OUTCOME );
            }
            if (line.startsWith("Kun ")) {
                return new StepMatch("Kun ", 4, ACTION );
            }
            if (line.startsWith("Ja ")) {
                return new StepMatch("Ja ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Fr implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fonctionnalité")) {
                return new Match("Fonctionnalité", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contexte")) {
                return new Match("Contexte", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Règle")) {
                return new Match("Règle", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Plan du Scénario")) {
                return new Match("Plan du Scénario", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Plan du scénario")) {
                return new Match("Plan du scénario", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scénario")) {
                return new Match("Scénario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemple")) {
                return new Match("Exemple", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemples")) {
                return new Match("Exemples", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Etant donné que ")) {
                return new StepMatch("Etant donné que ", 16, CONTEXT );
            }
            if (line.startsWith("Étant donné que ")) {
                return new StepMatch("Étant donné que ", 16, CONTEXT );
            }
            if (line.startsWith("Étant donné qu'")) {
                return new StepMatch("Étant donné qu'", 15, CONTEXT );
            }
            if (line.startsWith("Etant donné qu'")) {
                return new StepMatch("Etant donné qu'", 15, CONTEXT );
            }
            if (line.startsWith("Etant données ")) {
                return new StepMatch("Etant données ", 14, CONTEXT );
            }
            if (line.startsWith("Étant données ")) {
                return new StepMatch("Étant données ", 14, CONTEXT );
            }
            if (line.startsWith("Etant donnés ")) {
                return new StepMatch("Etant donnés ", 13, CONTEXT );
            }
            if (line.startsWith("Étant donnée ")) {
                return new StepMatch("Étant donnée ", 13, CONTEXT );
            }
            if (line.startsWith("Etant donnée ")) {
                return new StepMatch("Etant donnée ", 13, CONTEXT );
            }
            if (line.startsWith("Étant donnés ")) {
                return new StepMatch("Étant donnés ", 13, CONTEXT );
            }
            if (line.startsWith("Etant donné ")) {
                return new StepMatch("Etant donné ", 12, CONTEXT );
            }
            if (line.startsWith("Étant donné ")) {
                return new StepMatch("Étant donné ", 12, CONTEXT );
            }
            if (line.startsWith("Sachant que ")) {
                return new StepMatch("Sachant que ", 12, CONTEXT );
            }
            if (line.startsWith("Sachant qu'")) {
                return new StepMatch("Sachant qu'", 11, CONTEXT );
            }
            if (line.startsWith("Mais que ")) {
                return new StepMatch("Mais que ", 9, CONJUNCTION );
            }
            if (line.startsWith("Mais qu'")) {
                return new StepMatch("Mais qu'", 8, CONJUNCTION );
            }
            if (line.startsWith("Lorsque ")) {
                return new StepMatch("Lorsque ", 8, ACTION );
            }
            if (line.startsWith("Sachant ")) {
                return new StepMatch("Sachant ", 8, CONTEXT );
            }
            if (line.startsWith("Et que ")) {
                return new StepMatch("Et que ", 7, CONJUNCTION );
            }
            if (line.startsWith("Lorsqu'")) {
                return new StepMatch("Lorsqu'", 7, ACTION );
            }
            if (line.startsWith("Et qu'")) {
                return new StepMatch("Et qu'", 6, CONJUNCTION );
            }
            if (line.startsWith("Alors ")) {
                return new StepMatch("Alors ", 6, OUTCOME );
            }
            if (line.startsWith("Quand ")) {
                return new StepMatch("Quand ", 6, ACTION );
            }
            if (line.startsWith("Soit ")) {
                return new StepMatch("Soit ", 5, CONTEXT );
            }
            if (line.startsWith("Mais ")) {
                return new StepMatch("Mais ", 5, CONJUNCTION );
            }
            if (line.startsWith("Donc ")) {
                return new StepMatch("Donc ", 5, OUTCOME );
            }
            if (line.startsWith("Et ")) {
                return new StepMatch("Et ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ga implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Gné")) {
                return new Match("Gné", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cúlra")) {
                return new Match("Cúlra", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Riail")) {
                return new Match("Riail", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cás Achomair")) {
                return new Match("Cás Achomair", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Sampla")) {
                return new Match("Sampla", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cás")) {
                return new Match("Cás", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Samplaí")) {
                return new Match("Samplaí", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Cuir i gcás nach ")) {
                return new StepMatch("Cuir i gcás nach ", 17, CONTEXT );
            }
            if (line.startsWith("Cuir i gcás gur ")) {
                return new StepMatch("Cuir i gcás gur ", 16, CONTEXT );
            }
            if (line.startsWith("Cuir i gcás nár ")) {
                return new StepMatch("Cuir i gcás nár ", 16, CONTEXT );
            }
            if (line.startsWith("Cuir i gcás go ")) {
                return new StepMatch("Cuir i gcás go ", 15, CONTEXT );
            }
            if (line.startsWith("Nuair nach ")) {
                return new StepMatch("Nuair nach ", 11, ACTION );
            }
            if (line.startsWith("Nuair nár ")) {
                return new StepMatch("Nuair nár ", 10, ACTION );
            }
            if (line.startsWith("Nuair ba ")) {
                return new StepMatch("Nuair ba ", 9, ACTION );
            }
            if (line.startsWith("Nuair a ")) {
                return new StepMatch("Nuair a ", 8, ACTION );
            }
            if (line.startsWith("Ansin ")) {
                return new StepMatch("Ansin ", 6, OUTCOME );
            }
            if (line.startsWith("Agus ")) {
                return new StepMatch("Agus ", 5, CONJUNCTION );
            }
            if (line.startsWith("Ach ")) {
                return new StepMatch("Ach ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Gj implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("વ્યાપાર જરૂર")) {
                return new Match("વ્યાપાર જરૂર", 12 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ક્ષમતા")) {
                return new Match("ક્ષમતા", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("લક્ષણ")) {
                return new Match("લક્ષણ", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("બેકગ્રાઉન્ડ")) {
                return new Match("બેકગ્રાઉન્ડ", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("નિયમ")) {
                return new Match("નિયમ", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("પરિદ્દશ્ય રૂપરેખા")) {
                return new Match("પરિદ્દશ્ય રૂપરેખા", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("પરિદ્દશ્ય ઢાંચો")) {
                return new Match("પરિદ્દશ્ય ઢાંચો", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("સ્થિતિ")) {
                return new Match("સ્થિતિ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ઉદાહરણ")) {
                return new Match("ઉદાહરણ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ઉદાહરણો")) {
                return new Match("ઉદાહરણો", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("આપેલ છે ")) {
                return new StepMatch("આપેલ છે ", 8, CONTEXT );
            }
            if (line.startsWith("ક્યારે ")) {
                return new StepMatch("ક્યારે ", 7, ACTION );
            }
            if (line.startsWith("અને ")) {
                return new StepMatch("અને ", 4, CONJUNCTION );
            }
            if (line.startsWith("પછી ")) {
                return new StepMatch("પછી ", 4, OUTCOME );
            }
            if (line.startsWith("પણ ")) {
                return new StepMatch("પણ ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Gl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Característica")) {
                return new Match("Característica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contexto")) {
                return new Match("Contexto", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esbozo do escenario")) {
                return new Match("Esbozo do escenario", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Escenario")) {
                return new Match("Escenario", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new Match("Exemplo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new Match("Exemplos", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Dadas ")) {
                return new StepMatch("Dadas ", 6, CONTEXT );
            }
            if (line.startsWith("Dados ")) {
                return new StepMatch("Dados ", 6, CONTEXT );
            }
            if (line.startsWith("Cando ")) {
                return new StepMatch("Cando ", 6, ACTION );
            }
            if (line.startsWith("Entón ")) {
                return new StepMatch("Entón ", 6, OUTCOME );
            }
            if (line.startsWith("Mais ")) {
                return new StepMatch("Mais ", 5, CONJUNCTION );
            }
            if (line.startsWith("Dada ")) {
                return new StepMatch("Dada ", 5, CONTEXT );
            }
            if (line.startsWith("Dado ")) {
                return new StepMatch("Dado ", 5, CONTEXT );
            }
            if (line.startsWith("Logo ")) {
                return new StepMatch("Logo ", 5, OUTCOME );
            }
            if (line.startsWith("Pero ")) {
                return new StepMatch("Pero ", 5, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class He implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("תכונה")) {
                return new Match("תכונה", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("רקע")) {
                return new Match("רקע", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("כלל")) {
                return new Match("כלל", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("תבנית תרחיש")) {
                return new Match("תבנית תרחיש", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("דוגמא")) {
                return new Match("דוגמא", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("תרחיש")) {
                return new Match("תרחיש", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("דוגמאות")) {
                return new Match("דוגמאות", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("בהינתן ")) {
                return new StepMatch("בהינתן ", 7, CONTEXT );
            }
            if (line.startsWith("כאשר ")) {
                return new StepMatch("כאשר ", 5, ACTION );
            }
            if (line.startsWith("אזי ")) {
                return new StepMatch("אזי ", 4, OUTCOME );
            }
            if (line.startsWith("וגם ")) {
                return new StepMatch("וגם ", 4, CONJUNCTION );
            }
            if (line.startsWith("אבל ")) {
                return new StepMatch("אבל ", 4, CONJUNCTION );
            }
            if (line.startsWith("אז ")) {
                return new StepMatch("אז ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Hi implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("रूप लेख")) {
                return new Match("रूप लेख", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("पृष्ठभूमि")) {
                return new Match("पृष्ठभूमि", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("नियम")) {
                return new Match("नियम", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("परिदृश्य रूपरेखा")) {
                return new Match("परिदृश्य रूपरेखा", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("परिदृश्य")) {
                return new Match("परिदृश्य", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("उदाहरण")) {
                return new Match("उदाहरण", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("किन्तु ")) {
                return new StepMatch("किन्तु ", 7, CONJUNCTION );
            }
            if (line.startsWith("परन्तु ")) {
                return new StepMatch("परन्तु ", 7, CONJUNCTION );
            }
            if (line.startsWith("चूंकि ")) {
                return new StepMatch("चूंकि ", 6, CONTEXT );
            }
            if (line.startsWith("यदि ")) {
                return new StepMatch("यदि ", 4, CONTEXT );
            }
            if (line.startsWith("तथा ")) {
                return new StepMatch("तथा ", 4, CONJUNCTION );
            }
            if (line.startsWith("तदा ")) {
                return new StepMatch("तदा ", 4, OUTCOME );
            }
            if (line.startsWith("कदा ")) {
                return new StepMatch("कदा ", 4, ACTION );
            }
            if (line.startsWith("अगर ")) {
                return new StepMatch("अगर ", 4, CONTEXT );
            }
            if (line.startsWith("और ")) {
                return new StepMatch("और ", 3, CONJUNCTION );
            }
            if (line.startsWith("जब ")) {
                return new StepMatch("जब ", 3, ACTION );
            }
            if (line.startsWith("पर ")) {
                return new StepMatch("पर ", 3, CONJUNCTION );
            }
            if (line.startsWith("तब ")) {
                return new StepMatch("तब ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Hr implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Mogucnost")) {
                return new Match("Mogucnost", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Mogućnost")) {
                return new Match("Mogućnost", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Osobina")) {
                return new Match("Osobina", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new Match("Pozadina", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarij")) {
                return new Match("Scenarij", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primjer")) {
                return new Match("Primjer", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new Match("Koncept", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new Match("Skica", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new Match("Scenariji", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primjeri")) {
                return new Match("Primjeri", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Ukoliko ")) {
                return new StepMatch("Ukoliko ", 8, CONTEXT );
            }
            if (line.startsWith("Zadani ")) {
                return new StepMatch("Zadani ", 7, CONTEXT );
            }
            if (line.startsWith("Zadano ")) {
                return new StepMatch("Zadano ", 7, CONTEXT );
            }
            if (line.startsWith("Zadan ")) {
                return new StepMatch("Zadan ", 6, CONTEXT );
            }
            if (line.startsWith("Kada ")) {
                return new StepMatch("Kada ", 5, ACTION );
            }
            if (line.startsWith("Onda ")) {
                return new StepMatch("Onda ", 5, OUTCOME );
            }
            if (line.startsWith("Kad ")) {
                return new StepMatch("Kad ", 4, ACTION );
            }
            if (line.startsWith("Ali ")) {
                return new StepMatch("Ali ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ht implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Karakteristik")) {
                return new Match("Karakteristik", 13 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Fonksyonalite")) {
                return new Match("Fonksyonalite", 13 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Mak")) {
                return new Match("Mak", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontèks")) {
                return new Match("Kontèks", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Istorik")) {
                return new Match("Istorik", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Senaryo Deskripsyon")) {
                return new Match("Senaryo Deskripsyon", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Senaryo deskripsyon")) {
                return new Match("Senaryo deskripsyon", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Dyagram Senaryo")) {
                return new Match("Dyagram Senaryo", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Dyagram senaryo")) {
                return new Match("Dyagram senaryo", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Plan senaryo")) {
                return new Match("Plan senaryo", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Plan Senaryo")) {
                return new Match("Plan Senaryo", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Senaryo")) {
                return new Match("Senaryo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egzanp")) {
                return new Match("Egzanp", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Sipoze Ke ")) {
                return new StepMatch("Sipoze Ke ", 10, CONTEXT );
            }
            if (line.startsWith("Sipoze ke ")) {
                return new StepMatch("Sipoze ke ", 10, CONTEXT );
            }
            if (line.startsWith("Le sa a ")) {
                return new StepMatch("Le sa a ", 8, OUTCOME );
            }
            if (line.startsWith("Lè sa a ")) {
                return new StepMatch("Lè sa a ", 8, OUTCOME );
            }
            if (line.startsWith("Sipoze ")) {
                return new StepMatch("Sipoze ", 7, CONTEXT );
            }
            if (line.startsWith("Epi ")) {
                return new StepMatch("Epi ", 4, CONJUNCTION );
            }
            if (line.startsWith("Men ")) {
                return new StepMatch("Men ", 4, CONJUNCTION );
            }
            if (line.startsWith("Lè ")) {
                return new StepMatch("Lè ", 3, ACTION );
            }
            if (line.startsWith("Le ")) {
                return new StepMatch("Le ", 3, ACTION );
            }
            if (line.startsWith("Ak ")) {
                return new StepMatch("Ak ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Hu implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Jellemző")) {
                return new Match("Jellemző", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Háttér")) {
                return new Match("Háttér", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szabály")) {
                return new Match("Szabály", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Forgatókönyv vázlat")) {
                return new Match("Forgatókönyv vázlat", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Forgatókönyv")) {
                return new Match("Forgatókönyv", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Példa")) {
                return new Match("Példa", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Példák")) {
                return new Match("Példák", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Amennyiben ")) {
                return new StepMatch("Amennyiben ", 11, CONTEXT );
            }
            if (line.startsWith("Amikor ")) {
                return new StepMatch("Amikor ", 7, ACTION );
            }
            if (line.startsWith("Adott ")) {
                return new StepMatch("Adott ", 6, CONTEXT );
            }
            if (line.startsWith("Akkor ")) {
                return new StepMatch("Akkor ", 6, OUTCOME );
            }
            if (line.startsWith("Majd ")) {
                return new StepMatch("Majd ", 5, ACTION );
            }
            if (line.startsWith("Ha ")) {
                return new StepMatch("Ha ", 3, ACTION );
            }
            if (line.startsWith("És ")) {
                return new StepMatch("És ", 3, CONJUNCTION );
            }
            if (line.startsWith("De ")) {
                return new StepMatch("De ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Id implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fitur")) {
                return new Match("Fitur", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Latar Belakang")) {
                return new Match("Latar Belakang", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Dasar")) {
                return new Match("Dasar", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Aturan")) {
                return new Match("Aturan", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Garis-Besar Skenario")) {
                return new Match("Garis-Besar Skenario", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skenario konsep")) {
                return new Match("Skenario konsep", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skenario")) {
                return new Match("Skenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contoh")) {
                return new Match("Contoh", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Misal")) {
                return new Match("Misal", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Diasumsikan ")) {
                return new StepMatch("Diasumsikan ", 12, CONTEXT );
            }
            if (line.startsWith("Diketahui ")) {
                return new StepMatch("Diketahui ", 10, CONTEXT );
            }
            if (line.startsWith("Kemudian ")) {
                return new StepMatch("Kemudian ", 9, OUTCOME );
            }
            if (line.startsWith("Dengan ")) {
                return new StepMatch("Dengan ", 7, CONTEXT );
            }
            if (line.startsWith("Ketika ")) {
                return new StepMatch("Ketika ", 7, ACTION );
            }
            if (line.startsWith("Tetapi ")) {
                return new StepMatch("Tetapi ", 7, CONJUNCTION );
            }
            if (line.startsWith("Jika ")) {
                return new StepMatch("Jika ", 5, CONTEXT );
            }
            if (line.startsWith("Bila ")) {
                return new StepMatch("Bila ", 5, CONTEXT );
            }
            if (line.startsWith("Tapi ")) {
                return new StepMatch("Tapi ", 5, CONJUNCTION );
            }
            if (line.startsWith("Maka ")) {
                return new StepMatch("Maka ", 5, OUTCOME );
            }
            if (line.startsWith("Dan ")) {
                return new StepMatch("Dan ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Is implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eiginleiki")) {
                return new Match("Eiginleiki", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrunnur")) {
                return new Match("Bakgrunnur", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Lýsing Atburðarásar")) {
                return new Match("Lýsing Atburðarásar", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Lýsing Dæma")) {
                return new Match("Lýsing Dæma", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Atburðarás")) {
                return new Match("Atburðarás", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Atburðarásir")) {
                return new Match("Atburðarásir", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Dæmi")) {
                return new Match("Dæmi", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Þegar ")) {
                return new StepMatch("Þegar ", 6, ACTION );
            }
            if (line.startsWith("Og ")) {
                return new StepMatch("Og ", 3, CONJUNCTION );
            }
            if (line.startsWith("En ")) {
                return new StepMatch("En ", 3, CONJUNCTION );
            }
            if (line.startsWith("Ef ")) {
                return new StepMatch("Ef ", 3, CONTEXT );
            }
            if (line.startsWith("Þá ")) {
                return new StepMatch("Þá ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class It implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esigenza di Business")) {
                return new Match("Esigenza di Business", 20 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funzionalità")) {
                return new Match("Funzionalità", 12 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Abilità")) {
                return new Match("Abilità", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contesto")) {
                return new Match("Contesto", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regola")) {
                return new Match("Regola", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Schema dello scenario")) {
                return new Match("Schema dello scenario", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Esempio")) {
                return new Match("Esempio", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Esempi")) {
                return new Match("Esempi", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Allora ")) {
                return new StepMatch("Allora ", 7, OUTCOME );
            }
            if (line.startsWith("Quando ")) {
                return new StepMatch("Quando ", 7, ACTION );
            }
            if (line.startsWith("Dati ")) {
                return new StepMatch("Dati ", 5, CONTEXT );
            }
            if (line.startsWith("Dato ")) {
                return new StepMatch("Dato ", 5, CONTEXT );
            }
            if (line.startsWith("Data ")) {
                return new StepMatch("Data ", 5, CONTEXT );
            }
            if (line.startsWith("Date ")) {
                return new StepMatch("Date ", 5, CONTEXT );
            }
            if (line.startsWith("Ed ")) {
                return new StepMatch("Ed ", 3, CONJUNCTION );
            }
            if (line.startsWith("Ma ")) {
                return new StepMatch("Ma ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ja implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("フィーチャ")) {
                return new Match("フィーチャ", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("機能")) {
                return new Match("機能", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("背景")) {
                return new Match("背景", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ルール")) {
                return new Match("ルール", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("シナリオアウトライン")) {
                return new Match("シナリオアウトライン", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("シナリオテンプレート")) {
                return new Match("シナリオテンプレート", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("シナリオテンプレ")) {
                return new Match("シナリオテンプレ", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("テンプレ")) {
                return new Match("テンプレ", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("シナリオ")) {
                return new Match("シナリオ", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("サンプル")) {
                return new Match("サンプル", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("例")) {
                return new Match("例", 1  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ならば")) {
                return new StepMatch("ならば", 3, OUTCOME );
            }
            if (line.startsWith("ただし")) {
                return new StepMatch("ただし", 3, CONJUNCTION );
            }
            if (line.startsWith("しかし")) {
                return new StepMatch("しかし", 3, CONJUNCTION );
            }
            if (line.startsWith("前提")) {
                return new StepMatch("前提", 2, CONTEXT );
            }
            if (line.startsWith("然し")) {
                return new StepMatch("然し", 2, CONJUNCTION );
            }
            if (line.startsWith("もし")) {
                return new StepMatch("もし", 2, ACTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("但し")) {
                return new StepMatch("但し", 2, CONJUNCTION );
            }
            if (line.startsWith("且つ")) {
                return new StepMatch("且つ", 2, CONJUNCTION );
            }
            if (line.startsWith("かつ")) {
                return new StepMatch("かつ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Jv implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Fitur")) {
                return new Match("Fitur", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dasar")) {
                return new Match("Dasar", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konsep skenario")) {
                return new Match("Konsep skenario", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skenario")) {
                return new Match("Skenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Contone")) {
                return new Match("Contone", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Conto")) {
                return new Match("Conto", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Nalikaning ")) {
                return new StepMatch("Nalikaning ", 11, CONTEXT );
            }
            if (line.startsWith("Ananging ")) {
                return new StepMatch("Ananging ", 9, CONJUNCTION );
            }
            if (line.startsWith("Nanging ")) {
                return new StepMatch("Nanging ", 8, CONJUNCTION );
            }
            if (line.startsWith("Banjur ")) {
                return new StepMatch("Banjur ", 7, OUTCOME );
            }
            if (line.startsWith("Manawa ")) {
                return new StepMatch("Manawa ", 7, ACTION );
            }
            if (line.startsWith("Nalika ")) {
                return new StepMatch("Nalika ", 7, CONTEXT );
            }
            if (line.startsWith("Menawa ")) {
                return new StepMatch("Menawa ", 7, ACTION );
            }
            if (line.startsWith("Njuk ")) {
                return new StepMatch("Njuk ", 5, OUTCOME );
            }
            if (line.startsWith("Tapi ")) {
                return new StepMatch("Tapi ", 5, CONJUNCTION );
            }
            if (line.startsWith("Lan ")) {
                return new StepMatch("Lan ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ka implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("მოთხოვნა")) {
                return new Match("მოთხოვნა", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("თვისება")) {
                return new Match("თვისება", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("კონტექსტი")) {
                return new Match("კონტექსტი", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("წესი")) {
                return new Match("წესი", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("სცენარის შაბლონი")) {
                return new Match("სცენარის შაბლონი", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("სცენარის ნიმუში")) {
                return new Match("სცენარის ნიმუში", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("მაგალითად")) {
                return new Match("მაგალითად", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("მაგალითი")) {
                return new Match("მაგალითი", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("სცენარი")) {
                return new Match("სცენარი", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("შაბლონი")) {
                return new Match("შაბლონი", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ნიმუში")) {
                return new Match("ნიმუში", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("მაგ")) {
                return new Match("მაგ", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("მაგალითები")) {
                return new Match("მაგალითები", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("მოცემულია ")) {
                return new StepMatch("მოცემულია ", 10, CONTEXT );
            }
            if (line.startsWith("როგორც კი ")) {
                return new StepMatch("როგორც კი ", 10, ACTION );
            }
            if (line.startsWith("მოცემული ")) {
                return new StepMatch("მოცემული ", 9, CONTEXT );
            }
            if (line.startsWith("როდესაც ")) {
                return new StepMatch("როდესაც ", 8, ACTION );
            }
            if (line.startsWith("მაგრამ ")) {
                return new StepMatch("მაგრამ ", 7, CONJUNCTION );
            }
            if (line.startsWith("ვთქვათ ")) {
                return new StepMatch("ვთქვათ ", 7, CONTEXT );
            }
            if (line.startsWith("ასევე ")) {
                return new StepMatch("ასევე ", 6, CONJUNCTION );
            }
            if (line.startsWith("თუმცა ")) {
                return new StepMatch("თუმცა ", 6, CONJUNCTION );
            }
            if (line.startsWith("მაშინ ")) {
                return new StepMatch("მაშინ ", 6, OUTCOME );
            }
            if (line.startsWith("როცა ")) {
                return new StepMatch("როცა ", 5, ACTION );
            }
            if (line.startsWith("და ")) {
                return new StepMatch("და ", 3, CONJUNCTION );
            }
            if (line.startsWith("თუ ")) {
                return new StepMatch("თუ ", 3, ACTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Kn implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("ಹೆಚ್ಚಳ")) {
                return new Match("ಹೆಚ್ಚಳ", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("ಹಿನ್ನೆಲೆ")) {
                return new Match("ಹಿನ್ನೆಲೆ", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("ಕಥಾಸಾರಾಂಶ")) {
                return new Match("ಕಥಾಸಾರಾಂಶ", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ಉದಾಹರಣೆ")) {
                return new Match("ಉದಾಹರಣೆ", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ವಿವರಣೆ")) {
                return new Match("ವಿವರಣೆ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ಉದಾಹರಣೆಗಳು")) {
                return new Match("ಉದಾಹರಣೆಗಳು", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ಸ್ಥಿತಿಯನ್ನು ")) {
                return new StepMatch("ಸ್ಥಿತಿಯನ್ನು ", 12, ACTION );
            }
            if (line.startsWith("ನೀಡಿದ ")) {
                return new StepMatch("ನೀಡಿದ ", 7, CONTEXT );
            }
            if (line.startsWith("ಮತ್ತು ")) {
                return new StepMatch("ಮತ್ತು ", 6, CONJUNCTION );
            }
            if (line.startsWith("ನಂತರ ")) {
                return new StepMatch("ನಂತರ ", 5, OUTCOME );
            }
            if (line.startsWith("ಆದರೆ ")) {
                return new StepMatch("ಆದರೆ ", 5, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ko implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("기능")) {
                return new Match("기능", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("배경")) {
                return new Match("배경", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("시나리오 개요")) {
                return new Match("시나리오 개요", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("시나리오")) {
                return new Match("시나리오", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("예")) {
                return new Match("예", 1  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("그리고 ")) {
                return new StepMatch("그리고 ", 4, CONJUNCTION );
            }
            if (line.startsWith("하지만 ")) {
                return new StepMatch("하지만 ", 4, CONJUNCTION );
            }
            if (line.startsWith("그러면 ")) {
                return new StepMatch("그러면 ", 4, OUTCOME );
            }
            if (line.startsWith("만일 ")) {
                return new StepMatch("만일 ", 3, ACTION );
            }
            if (line.startsWith("먼저 ")) {
                return new StepMatch("먼저 ", 3, CONTEXT );
            }
            if (line.startsWith("조건 ")) {
                return new StepMatch("조건 ", 3, CONTEXT );
            }
            if (line.startsWith("만약 ")) {
                return new StepMatch("만약 ", 3, ACTION );
            }
            if (line.startsWith("단 ")) {
                return new StepMatch("단 ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Lt implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Savybė")) {
                return new Match("Savybė", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekstas")) {
                return new Match("Kontekstas", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenarijaus šablonas")) {
                return new Match("Scenarijaus šablonas", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenarijus")) {
                return new Match("Scenarijus", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Pavyzdys")) {
                return new Match("Pavyzdys", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pavyzdžiai")) {
                return new Match("Pavyzdžiai", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenarijai")) {
                return new Match("Scenarijai", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Variantai")) {
                return new Match("Variantai", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Duota ")) {
                return new StepMatch("Duota ", 6, CONTEXT );
            }
            if (line.startsWith("Tada ")) {
                return new StepMatch("Tada ", 5, OUTCOME );
            }
            if (line.startsWith("Kai ")) {
                return new StepMatch("Kai ", 4, ACTION );
            }
            if (line.startsWith("Bet ")) {
                return new StepMatch("Bet ", 4, CONJUNCTION );
            }
            if (line.startsWith("Ir ")) {
                return new StepMatch("Ir ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Lu implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funktionalitéit")) {
                return new Match("Funktionalitéit", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Hannergrond")) {
                return new Match("Hannergrond", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Plang vum Szenario")) {
                return new Match("Plang vum Szenario", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Szenario")) {
                return new Match("Szenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Beispill")) {
                return new Match("Beispill", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Beispiller")) {
                return new Match("Beispiller", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ugeholl ")) {
                return new StepMatch("ugeholl ", 8, CONTEXT );
            }
            if (line.startsWith("wann ")) {
                return new StepMatch("wann ", 5, ACTION );
            }
            if (line.startsWith("dann ")) {
                return new StepMatch("dann ", 5, OUTCOME );
            }
            if (line.startsWith("awer ")) {
                return new StepMatch("awer ", 5, CONJUNCTION );
            }
            if (line.startsWith("mä ")) {
                return new StepMatch("mä ", 3, CONJUNCTION );
            }
            if (line.startsWith("an ")) {
                return new StepMatch("an ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("a ")) {
                return new StepMatch("a ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Lv implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalitāte")) {
                return new Match("Funkcionalitāte", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Fīča")) {
                return new Match("Fīča", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Konteksts")) {
                return new Match("Konteksts", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Situācija")) {
                return new Match("Situācija", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenārijs pēc parauga")) {
                return new Match("Scenārijs pēc parauga", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenārijs")) {
                return new Match("Scenārijs", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Piemērs")) {
                return new Match("Piemērs", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Piemēri")) {
                return new Match("Piemēri", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Paraugs")) {
                return new Match("Paraugs", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Tad ")) {
                return new StepMatch("Tad ", 4, OUTCOME );
            }
            if (line.startsWith("Bet ")) {
                return new StepMatch("Bet ", 4, CONJUNCTION );
            }
            if (line.startsWith("Kad ")) {
                return new StepMatch("Kad ", 4, CONTEXT );
            }
            if (line.startsWith("Un ")) {
                return new StepMatch("Un ", 3, CONJUNCTION );
            }
            if (line.startsWith("Ja ")) {
                return new StepMatch("Ja ", 3, ACTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Mk_cyrl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функционалност")) {
                return new Match("Функционалност", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Бизнис потреба")) {
                return new Match("Бизнис потреба", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Можност")) {
                return new Match("Можност", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Содржина")) {
                return new Match("Содржина", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Контекст")) {
                return new Match("Контекст", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Преглед на сценарија")) {
                return new Match("Преглед на сценарија", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("На пример")) {
                return new Match("На пример", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарио")) {
                return new Match("Сценарио", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Концепт")) {
                return new Match("Концепт", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Пример")) {
                return new Match("Пример", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Скица")) {
                return new Match("Скица", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Сценарија")) {
                return new Match("Сценарија", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Примери")) {
                return new Match("Примери", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Дадено ")) {
                return new StepMatch("Дадено ", 7, CONTEXT );
            }
            if (line.startsWith("Дадена ")) {
                return new StepMatch("Дадена ", 7, CONTEXT );
            }
            if (line.startsWith("Тогаш ")) {
                return new StepMatch("Тогаш ", 6, OUTCOME );
            }
            if (line.startsWith("Кога ")) {
                return new StepMatch("Кога ", 5, ACTION );
            }
            if (line.startsWith("Но ")) {
                return new StepMatch("Но ", 3, CONJUNCTION );
            }
            if (line.startsWith("И ")) {
                return new StepMatch("И ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Mk_latn implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new Match("Funkcionalnost", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Biznis potreba")) {
                return new Match("Biznis potreba", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Mozhnost")) {
                return new Match("Mozhnost", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Sodrzhina")) {
                return new Match("Sodrzhina", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new Match("Kontekst", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pregled na scenarija")) {
                return new Match("Pregled na scenarija", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Na primer")) {
                return new Match("Na primer", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new Match("Koncept", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new Match("Skica", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenaria")) {
                return new Match("Scenaria", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new Match("Primeri", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Dadena ")) {
                return new StepMatch("Dadena ", 7, CONTEXT );
            }
            if (line.startsWith("Togash ")) {
                return new StepMatch("Togash ", 7, OUTCOME );
            }
            if (line.startsWith("Dadeno ")) {
                return new StepMatch("Dadeno ", 7, CONTEXT );
            }
            if (line.startsWith("Koga ")) {
                return new StepMatch("Koga ", 5, ACTION );
            }
            if (line.startsWith("No ")) {
                return new StepMatch("No ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ml implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("സവിശേഷത")) {
                return new Match("സവിശേഷത", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("പശ്ചാത്തലം")) {
                return new Match("പശ്ചാത്തലം", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("നിയമം")) {
                return new Match("നിയമം", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("സാഹചര്യത്തിന്റെ രൂപരേഖ")) {
                return new Match("സാഹചര്യത്തിന്റെ രൂപരേഖ", 22  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("രംഗം")) {
                return new Match("രംഗം", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ഉദാഹരണങ്ങൾ")) {
                return new Match("ഉദാഹരണങ്ങൾ", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("നൽകിയത്")) {
                return new StepMatch("നൽകിയത്", 7, CONTEXT );
            }
            if (line.startsWith("എപ്പോൾ")) {
                return new StepMatch("എപ്പോൾ", 7, ACTION );
            }
            if (line.startsWith("പിന്നെ")) {
                return new StepMatch("പിന്നെ", 6, OUTCOME );
            }
            if (line.startsWith("ഒപ്പം")) {
                return new StepMatch("ഒപ്പം", 5, CONJUNCTION );
            }
            if (line.startsWith("പക്ഷേ")) {
                return new StepMatch("പക്ഷേ", 5, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Mn implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функционал")) {
                return new Match("Функционал", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Функц")) {
                return new Match("Функц", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Агуулга")) {
                return new Match("Агуулга", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Сценарын төлөвлөгөө")) {
                return new Match("Сценарын төлөвлөгөө", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценар")) {
                return new Match("Сценар", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Тухайлбал")) {
                return new Match("Тухайлбал", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Өгөгдсөн нь ")) {
                return new StepMatch("Өгөгдсөн нь ", 12, CONTEXT );
            }
            if (line.startsWith("Үүний дараа ")) {
                return new StepMatch("Үүний дараа ", 12, OUTCOME );
            }
            if (line.startsWith("Тэгэхэд ")) {
                return new StepMatch("Тэгэхэд ", 8, OUTCOME );
            }
            if (line.startsWith("Тэгээд ")) {
                return new StepMatch("Тэгээд ", 7, CONJUNCTION );
            }
            if (line.startsWith("Гэхдээ ")) {
                return new StepMatch("Гэхдээ ", 7, CONJUNCTION );
            }
            if (line.startsWith("Харин ")) {
                return new StepMatch("Харин ", 6, CONJUNCTION );
            }
            if (line.startsWith("Хэрэв ")) {
                return new StepMatch("Хэрэв ", 6, ACTION );
            }
            if (line.startsWith("Анх ")) {
                return new StepMatch("Анх ", 4, CONTEXT );
            }
            if (line.startsWith("Мөн ")) {
                return new StepMatch("Мөн ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Mr implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("वैशिष्ट्य")) {
                return new Match("वैशिष्ट्य", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("सुविधा")) {
                return new Match("सुविधा", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("पार्श्वभूमी")) {
                return new Match("पार्श्वभूमी", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("नियम")) {
                return new Match("नियम", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("परिदृश्य रूपरेखा")) {
                return new Match("परिदृश्य रूपरेखा", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("परिदृश्य")) {
                return new Match("परिदृश्य", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("उदाहरण")) {
                return new Match("उदाहरण", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("दिलेल्या प्रमाणे ")) {
                return new StepMatch("दिलेल्या प्रमाणे ", 17, CONTEXT );
            }
            if (line.startsWith("तेव्हा ")) {
                return new StepMatch("तेव्हा ", 7, OUTCOME );
            }
            if (line.startsWith("जेव्हा ")) {
                return new StepMatch("जेव्हा ", 7, ACTION );
            }
            if (line.startsWith("परंतु ")) {
                return new StepMatch("परंतु ", 6, CONJUNCTION );
            }
            if (line.startsWith("तसेच ")) {
                return new StepMatch("तसेच ", 5, CONJUNCTION );
            }
            if (line.startsWith("आणि ")) {
                return new StepMatch("आणि ", 4, CONJUNCTION );
            }
            if (line.startsWith("पण ")) {
                return new StepMatch("पण ", 3, CONJUNCTION );
            }
            if (line.startsWith("मग ")) {
                return new StepMatch("मग ", 3, OUTCOME );
            }
            if (line.startsWith("जर")) {
                return new StepMatch("जर", 2, CONTEXT );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ne implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("विशेषता")) {
                return new Match("विशेषता", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("सुविधा")) {
                return new Match("सुविधा", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("पृष्ठभूमी")) {
                return new Match("पृष्ठभूमी", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("नियम")) {
                return new Match("नियम", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("परिदृश्य रूपरेखा")) {
                return new Match("परिदृश्य रूपरेखा", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("परिदृश्य")) {
                return new Match("परिदृश्य", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("उदाहरणहरु")) {
                return new Match("उदाहरणहरु", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("उदाहरण")) {
                return new Match("उदाहरण", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("त्यसपछि ")) {
                return new StepMatch("त्यसपछि ", 8, OUTCOME );
            }
            if (line.startsWith("दिइएको ")) {
                return new StepMatch("दिइएको ", 7, CONTEXT );
            }
            if (line.startsWith("दिएको ")) {
                return new StepMatch("दिएको ", 6, CONTEXT );
            }
            if (line.startsWith("यदि ")) {
                return new StepMatch("यदि ", 4, CONTEXT );
            }
            if (line.startsWith("अनि ")) {
                return new StepMatch("अनि ", 4, CONJUNCTION );
            }
            if (line.startsWith("अनी ")) {
                return new StepMatch("अनी ", 4, OUTCOME );
            }
            if (line.startsWith("जब ")) {
                return new StepMatch("जब ", 3, ACTION );
            }
            if (line.startsWith("तर ")) {
                return new StepMatch("तर ", 3, CONJUNCTION );
            }
            if (line.startsWith("र ")) {
                return new StepMatch("र ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Nl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Functionaliteit")) {
                return new Match("Functionaliteit", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Achtergrond")) {
                return new Match("Achtergrond", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new Match("Regel", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstract Scenario")) {
                return new Match("Abstract Scenario", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Voorbeeld")) {
                return new Match("Voorbeeld", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Voorbeelden")) {
                return new Match("Voorbeelden", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Wanneer ")) {
                return new StepMatch("Wanneer ", 8, ACTION );
            }
            if (line.startsWith("Gegeven ")) {
                return new StepMatch("Gegeven ", 8, CONTEXT );
            }
            if (line.startsWith("Maar ")) {
                return new StepMatch("Maar ", 5, CONJUNCTION );
            }
            if (line.startsWith("Stel ")) {
                return new StepMatch("Stel ", 5, CONTEXT );
            }
            if (line.startsWith("Als ")) {
                return new StepMatch("Als ", 4, ACTION );
            }
            if (line.startsWith("Dan ")) {
                return new StepMatch("Dan ", 4, OUTCOME );
            }
            if (line.startsWith("En ")) {
                return new StepMatch("En ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class No implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskap")) {
                return new Match("Egenskap", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrunn")) {
                return new Match("Bakgrunn", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new Match("Regel", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new Match("Abstrakt Scenario", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariomal")) {
                return new Match("Scenariomal", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Eksempel")) {
                return new Match("Eksempel", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Eksempler")) {
                return new Match("Eksempler", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Gitt ")) {
                return new StepMatch("Gitt ", 5, CONTEXT );
            }
            if (line.startsWith("Når ")) {
                return new StepMatch("Når ", 4, ACTION );
            }
            if (line.startsWith("Men ")) {
                return new StepMatch("Men ", 4, CONJUNCTION );
            }
            if (line.startsWith("Og ")) {
                return new StepMatch("Og ", 3, CONJUNCTION );
            }
            if (line.startsWith("Så ")) {
                return new StepMatch("Så ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Pa implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("ਨਕਸ਼ ਨੁਹਾਰ")) {
                return new Match("ਨਕਸ਼ ਨੁਹਾਰ", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ਮੁਹਾਂਦਰਾ")) {
                return new Match("ਮੁਹਾਂਦਰਾ", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ਖਾਸੀਅਤ")) {
                return new Match("ਖਾਸੀਅਤ", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("ਪਿਛੋਕੜ")) {
                return new Match("ਪਿਛੋਕੜ", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("ਪਟਕਥਾ ਰੂਪ ਰੇਖਾ")) {
                return new Match("ਪਟਕਥਾ ਰੂਪ ਰੇਖਾ", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ਪਟਕਥਾ ਢਾਂਚਾ")) {
                return new Match("ਪਟਕਥਾ ਢਾਂਚਾ", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ਉਦਾਹਰਨ")) {
                return new Match("ਉਦਾਹਰਨ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ਪਟਕਥਾ")) {
                return new Match("ਪਟਕਥਾ", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ਉਦਾਹਰਨਾਂ")) {
                return new Match("ਉਦਾਹਰਨਾਂ", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ਜਿਵੇਂ ਕਿ ")) {
                return new StepMatch("ਜਿਵੇਂ ਕਿ ", 9, CONTEXT );
            }
            if (line.startsWith("ਜਦੋਂ ")) {
                return new StepMatch("ਜਦੋਂ ", 5, ACTION );
            }
            if (line.startsWith("ਜੇਕਰ ")) {
                return new StepMatch("ਜੇਕਰ ", 5, CONTEXT );
            }
            if (line.startsWith("ਅਤੇ ")) {
                return new StepMatch("ਅਤੇ ", 4, CONJUNCTION );
            }
            if (line.startsWith("ਤਦ ")) {
                return new StepMatch("ਤਦ ", 3, OUTCOME );
            }
            if (line.startsWith("ਪਰ ")) {
                return new StepMatch("ਪਰ ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Pl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Potrzeba biznesowa")) {
                return new Match("Potrzeba biznesowa", 18 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Właściwość")) {
                return new Match("Właściwość", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funkcja")) {
                return new Match("Funkcja", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Aspekt")) {
                return new Match("Aspekt", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Założenia")) {
                return new Match("Założenia", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Reguła")) {
                return new Match("Reguła", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Zasada")) {
                return new Match("Zasada", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Szablon scenariusza")) {
                return new Match("Szablon scenariusza", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariusz")) {
                return new Match("Scenariusz", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Przykład")) {
                return new Match("Przykład", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Przykłady")) {
                return new Match("Przykłady", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Zakładając, że ")) {
                return new StepMatch("Zakładając, że ", 15, CONTEXT );
            }
            if (line.startsWith("Zakładając ")) {
                return new StepMatch("Zakładając ", 11, CONTEXT );
            }
            if (line.startsWith("Jeżeli ")) {
                return new StepMatch("Jeżeli ", 7, ACTION );
            }
            if (line.startsWith("Wtedy ")) {
                return new StepMatch("Wtedy ", 6, OUTCOME );
            }
            if (line.startsWith("Jeśli ")) {
                return new StepMatch("Jeśli ", 6, ACTION );
            }
            if (line.startsWith("Kiedy ")) {
                return new StepMatch("Kiedy ", 6, ACTION );
            }
            if (line.startsWith("Mając ")) {
                return new StepMatch("Mając ", 6, CONTEXT );
            }
            if (line.startsWith("Oraz ")) {
                return new StepMatch("Oraz ", 5, CONJUNCTION );
            }
            if (line.startsWith("Gdy ")) {
                return new StepMatch("Gdy ", 4, ACTION );
            }
            if (line.startsWith("Ale ")) {
                return new StepMatch("Ale ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Pt implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funcionalidade")) {
                return new Match("Funcionalidade", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Característica")) {
                return new Match("Característica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Caracteristica")) {
                return new Match("Caracteristica", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cenário de Fundo")) {
                return new Match("Cenário de Fundo", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cenario de Fundo")) {
                return new Match("Cenario de Fundo", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Contexto")) {
                return new Match("Contexto", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Fundo")) {
                return new Match("Fundo", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regra")) {
                return new Match("Regra", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Delineacao do Cenario")) {
                return new Match("Delineacao do Cenario", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Delineação do Cenário")) {
                return new Match("Delineação do Cenário", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Esquema do Cenário")) {
                return new Match("Esquema do Cenário", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Esquema do Cenario")) {
                return new Match("Esquema do Cenario", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemplo")) {
                return new Match("Exemplo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cenário")) {
                return new Match("Cenário", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cenario")) {
                return new Match("Cenario", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Cenários")) {
                return new Match("Cenários", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemplos")) {
                return new Match("Exemplos", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Cenarios")) {
                return new Match("Cenarios", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Quando ")) {
                return new StepMatch("Quando ", 7, ACTION );
            }
            if (line.startsWith("Entao ")) {
                return new StepMatch("Entao ", 6, OUTCOME );
            }
            if (line.startsWith("Dadas ")) {
                return new StepMatch("Dadas ", 6, CONTEXT );
            }
            if (line.startsWith("Então ")) {
                return new StepMatch("Então ", 6, OUTCOME );
            }
            if (line.startsWith("Dados ")) {
                return new StepMatch("Dados ", 6, CONTEXT );
            }
            if (line.startsWith("Dada ")) {
                return new StepMatch("Dada ", 5, CONTEXT );
            }
            if (line.startsWith("Dado ")) {
                return new StepMatch("Dado ", 5, CONTEXT );
            }
            if (line.startsWith("Mas ")) {
                return new StepMatch("Mas ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("E ")) {
                return new StepMatch("E ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ro implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funcţionalitate")) {
                return new Match("Funcţionalitate", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Functionalitate")) {
                return new Match("Functionalitate", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funcționalitate")) {
                return new Match("Funcționalitate", 15 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Context")) {
                return new Match("Context", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Structură scenariu")) {
                return new Match("Structură scenariu", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Structura scenariu")) {
                return new Match("Structura scenariu", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariu")) {
                return new Match("Scenariu", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Exemplu")) {
                return new Match("Exemplu", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exemple")) {
                return new Match("Exemple", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Daţi fiind ")) {
                return new StepMatch("Daţi fiind ", 11, CONTEXT );
            }
            if (line.startsWith("Dați fiind ")) {
                return new StepMatch("Dați fiind ", 11, CONTEXT );
            }
            if (line.startsWith("Date fiind ")) {
                return new StepMatch("Date fiind ", 11, CONTEXT );
            }
            if (line.startsWith("Dati fiind ")) {
                return new StepMatch("Dati fiind ", 11, CONTEXT );
            }
            if (line.startsWith("Dat fiind ")) {
                return new StepMatch("Dat fiind ", 10, CONTEXT );
            }
            if (line.startsWith("Dată fiind")) {
                return new StepMatch("Dată fiind", 10, CONTEXT );
            }
            if (line.startsWith("Atunci ")) {
                return new StepMatch("Atunci ", 7, OUTCOME );
            }
            if (line.startsWith("Cand ")) {
                return new StepMatch("Cand ", 5, ACTION );
            }
            if (line.startsWith("Când ")) {
                return new StepMatch("Când ", 5, ACTION );
            }
            if (line.startsWith("Dar ")) {
                return new StepMatch("Dar ", 4, CONJUNCTION );
            }
            if (line.startsWith("Și ")) {
                return new StepMatch("Și ", 3, CONJUNCTION );
            }
            if (line.startsWith("Si ")) {
                return new StepMatch("Si ", 3, CONJUNCTION );
            }
            if (line.startsWith("Şi ")) {
                return new StepMatch("Şi ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ru implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функциональность")) {
                return new Match("Функциональность", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Функционал")) {
                return new Match("Функционал", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Свойство")) {
                return new Match("Свойство", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Функция")) {
                return new Match("Функция", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Фича")) {
                return new Match("Фича", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Предыстория")) {
                return new Match("Предыстория", 11 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Контекст")) {
                return new Match("Контекст", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Правило")) {
                return new Match("Правило", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Структура сценария")) {
                return new Match("Структура сценария", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Шаблон сценария")) {
                return new Match("Шаблон сценария", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарий")) {
                return new Match("Сценарий", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Пример")) {
                return new Match("Пример", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Примеры")) {
                return new Match("Примеры", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("К тому же ")) {
                return new StepMatch("К тому же ", 10, CONJUNCTION );
            }
            if (line.startsWith("Допустим ")) {
                return new StepMatch("Допустим ", 9, CONTEXT );
            }
            if (line.startsWith("Тогда ")) {
                return new StepMatch("Тогда ", 6, OUTCOME );
            }
            if (line.startsWith("Пусть ")) {
                return new StepMatch("Пусть ", 6, CONTEXT );
            }
            if (line.startsWith("Иначе ")) {
                return new StepMatch("Иначе ", 6, CONJUNCTION );
            }
            if (line.startsWith("Также ")) {
                return new StepMatch("Также ", 6, CONJUNCTION );
            }
            if (line.startsWith("Когда ")) {
                return new StepMatch("Когда ", 6, ACTION );
            }
            if (line.startsWith("Затем ")) {
                return new StepMatch("Затем ", 6, OUTCOME );
            }
            if (line.startsWith("Дано ")) {
                return new StepMatch("Дано ", 5, CONTEXT );
            }
            if (line.startsWith("Если ")) {
                return new StepMatch("Если ", 5, ACTION );
            }
            if (line.startsWith("Но ")) {
                return new StepMatch("Но ", 3, CONJUNCTION );
            }
            if (line.startsWith("То ")) {
                return new StepMatch("То ", 3, OUTCOME );
            }
            if (line.startsWith("И ")) {
                return new StepMatch("И ", 2, CONJUNCTION );
            }
            if (line.startsWith("А ")) {
                return new StepMatch("А ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Sk implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Požiadavka")) {
                return new Match("Požiadavka", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Vlastnosť")) {
                return new Match("Vlastnosť", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funkcia")) {
                return new Match("Funkcia", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pozadie")) {
                return new Match("Pozadie", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Osnova Scenára")) {
                return new Match("Osnova Scenára", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Náčrt Scenára")) {
                return new Match("Náčrt Scenára", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Náčrt Scenáru")) {
                return new Match("Náčrt Scenáru", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Príklad")) {
                return new Match("Príklad", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenár")) {
                return new Match("Scenár", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Príklady")) {
                return new Match("Príklady", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za predpokladu ")) {
                return new StepMatch("Za predpokladu ", 15, CONTEXT );
            }
            if (line.startsWith("A taktiež ")) {
                return new StepMatch("A taktiež ", 10, CONJUNCTION );
            }
            if (line.startsWith("A zároveň ")) {
                return new StepMatch("A zároveň ", 10, CONJUNCTION );
            }
            if (line.startsWith("Pokiaľ ")) {
                return new StepMatch("Pokiaľ ", 7, CONTEXT );
            }
            if (line.startsWith("A tiež ")) {
                return new StepMatch("A tiež ", 7, CONJUNCTION );
            }
            if (line.startsWith("Potom ")) {
                return new StepMatch("Potom ", 6, OUTCOME );
            }
            if (line.startsWith("Tak ")) {
                return new StepMatch("Tak ", 4, OUTCOME );
            }
            if (line.startsWith("Keď ")) {
                return new StepMatch("Keď ", 4, ACTION );
            }
            if (line.startsWith("Ale ")) {
                return new StepMatch("Ale ", 4, CONJUNCTION );
            }
            if (line.startsWith("Ak ")) {
                return new StepMatch("Ak ", 3, ACTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("A ")) {
                return new StepMatch("A ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Sl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new Match("Funkcionalnost", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Značilnost")) {
                return new Match("Značilnost", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Možnosti")) {
                return new Match("Možnosti", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Moznosti")) {
                return new Match("Moznosti", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Lastnost")) {
                return new Match("Lastnost", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Funkcija")) {
                return new Match("Funkcija", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new Match("Kontekst", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Osnova")) {
                return new Match("Osnova", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Ozadje")) {
                return new Match("Ozadje", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Struktura scenarija")) {
                return new Match("Struktura scenarija", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Oris scenarija")) {
                return new Match("Oris scenarija", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenarij")) {
                return new Match("Scenarij", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Osnutek")) {
                return new Match("Osnutek", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new Match("Koncept", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primer")) {
                return new Match("Primer", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new Match("Skica", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new Match("Scenariji", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new Match("Primeri", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Privzeto ")) {
                return new StepMatch("Privzeto ", 9, CONTEXT );
            }
            if (line.startsWith("Vendar ")) {
                return new StepMatch("Vendar ", 7, CONJUNCTION );
            }
            if (line.startsWith("Podano ")) {
                return new StepMatch("Podano ", 7, CONTEXT );
            }
            if (line.startsWith("Zaradi ")) {
                return new StepMatch("Zaradi ", 7, CONTEXT );
            }
            if (line.startsWith("Takrat ")) {
                return new StepMatch("Takrat ", 7, OUTCOME );
            }
            if (line.startsWith("Kadar ")) {
                return new StepMatch("Kadar ", 6, ACTION );
            }
            if (line.startsWith("Ampak ")) {
                return new StepMatch("Ampak ", 6, CONJUNCTION );
            }
            if (line.startsWith("Potem ")) {
                return new StepMatch("Potem ", 6, OUTCOME );
            }
            if (line.startsWith("Nato ")) {
                return new StepMatch("Nato ", 5, OUTCOME );
            }
            if (line.startsWith("Dano ")) {
                return new StepMatch("Dano ", 5, CONTEXT );
            }
            if (line.startsWith("Toda ")) {
                return new StepMatch("Toda ", 5, CONJUNCTION );
            }
            if (line.startsWith("Ter ")) {
                return new StepMatch("Ter ", 4, CONJUNCTION );
            }
            if (line.startsWith("Če ")) {
                return new StepMatch("Če ", 3, ACTION );
            }
            if (line.startsWith("In ")) {
                return new StepMatch("In ", 3, CONJUNCTION );
            }
            if (line.startsWith("Ko ")) {
                return new StepMatch("Ko ", 3, ACTION );
            }
            if (line.startsWith("Ce ")) {
                return new StepMatch("Ce ", 3, ACTION );
            }
            return null;
        }
    }
    private static final class Sr_cyrl implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функционалност")) {
                return new Match("Функционалност", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Могућност")) {
                return new Match("Могућност", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Особина")) {
                return new Match("Особина", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Позадина")) {
                return new Match("Позадина", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Контекст")) {
                return new Match("Контекст", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Основа")) {
                return new Match("Основа", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Правило")) {
                return new Match("Правило", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Структура сценарија")) {
                return new Match("Структура сценарија", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарио")) {
                return new Match("Сценарио", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Концепт")) {
                return new Match("Концепт", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Пример")) {
                return new Match("Пример", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Скица")) {
                return new Match("Скица", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Сценарији")) {
                return new Match("Сценарији", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Примери")) {
                return new Match("Примери", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("За дати ")) {
                return new StepMatch("За дати ", 8, CONTEXT );
            }
            if (line.startsWith("За дато ")) {
                return new StepMatch("За дато ", 8, CONTEXT );
            }
            if (line.startsWith("За дате ")) {
                return new StepMatch("За дате ", 8, CONTEXT );
            }
            if (line.startsWith("Онда ")) {
                return new StepMatch("Онда ", 5, OUTCOME );
            }
            if (line.startsWith("Када ")) {
                return new StepMatch("Када ", 5, ACTION );
            }
            if (line.startsWith("Кад ")) {
                return new StepMatch("Кад ", 4, ACTION );
            }
            if (line.startsWith("Али ")) {
                return new StepMatch("Али ", 4, CONJUNCTION );
            }
            if (line.startsWith("И ")) {
                return new StepMatch("И ", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Sr_latn implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Funkcionalnost")) {
                return new Match("Funkcionalnost", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Mogucnost")) {
                return new Match("Mogucnost", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Mogućnost")) {
                return new Match("Mogućnost", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Osobina")) {
                return new Match("Osobina", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kontekst")) {
                return new Match("Kontekst", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Pozadina")) {
                return new Match("Pozadina", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Osnova")) {
                return new Match("Osnova", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Pravilo")) {
                return new Match("Pravilo", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Struktura scenarija")) {
                return new Match("Struktura scenarija", 19  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Koncept")) {
                return new Match("Koncept", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primer")) {
                return new Match("Primer", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Skica")) {
                return new Match("Skica", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Scenariji")) {
                return new Match("Scenariji", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Primeri")) {
                return new Match("Primeri", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Za dati ")) {
                return new StepMatch("Za dati ", 8, CONTEXT );
            }
            if (line.startsWith("Za date ")) {
                return new StepMatch("Za date ", 8, CONTEXT );
            }
            if (line.startsWith("Za dato ")) {
                return new StepMatch("Za dato ", 8, CONTEXT );
            }
            if (line.startsWith("Kada ")) {
                return new StepMatch("Kada ", 5, ACTION );
            }
            if (line.startsWith("Onda ")) {
                return new StepMatch("Onda ", 5, OUTCOME );
            }
            if (line.startsWith("Kad ")) {
                return new StepMatch("Kad ", 4, ACTION );
            }
            if (line.startsWith("Ali ")) {
                return new StepMatch("Ali ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("I ")) {
                return new StepMatch("I ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Sv implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Egenskap")) {
                return new Match("Egenskap", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bakgrund")) {
                return new Match("Bakgrund", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Regel")) {
                return new Match("Regel", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Abstrakt Scenario")) {
                return new Match("Abstrakt Scenario", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenariomall")) {
                return new Match("Scenariomall", 12  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Scenario")) {
                return new Match("Scenario", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Exempel")) {
                return new Match("Exempel", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Givet ")) {
                return new StepMatch("Givet ", 6, CONTEXT );
            }
            if (line.startsWith("När ")) {
                return new StepMatch("När ", 4, ACTION );
            }
            if (line.startsWith("Och ")) {
                return new StepMatch("Och ", 4, CONJUNCTION );
            }
            if (line.startsWith("Men ")) {
                return new StepMatch("Men ", 4, CONJUNCTION );
            }
            if (line.startsWith("Så ")) {
                return new StepMatch("Så ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Ta implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("வணிக தேவை")) {
                return new Match("வணிக தேவை", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("அம்சம்")) {
                return new Match("அம்சம்", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("திறன்")) {
                return new Match("திறன்", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("பின்னணி")) {
                return new Match("பின்னணி", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("காட்சி வார்ப்புரு")) {
                return new Match("காட்சி வார்ப்புரு", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("காட்சி சுருக்கம்")) {
                return new Match("காட்சி சுருக்கம்", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("உதாரணமாக")) {
                return new Match("உதாரணமாக", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("காட்சி")) {
                return new Match("காட்சி", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("எடுத்துக்காட்டுகள்")) {
                return new Match("எடுத்துக்காட்டுகள்", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("நிலைமைகளில்")) {
                return new Match("நிலைமைகளில்", 11  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("காட்சிகள்")) {
                return new Match("காட்சிகள்", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("கொடுக்கப்பட்ட ")) {
                return new StepMatch("கொடுக்கப்பட்ட ", 15, CONTEXT );
            }
            if (line.startsWith("அப்பொழுது ")) {
                return new StepMatch("அப்பொழுது ", 11, OUTCOME );
            }
            if (line.startsWith("எப்போது ")) {
                return new StepMatch("எப்போது ", 9, ACTION );
            }
            if (line.startsWith("மற்றும் ")) {
                return new StepMatch("மற்றும் ", 8, CONJUNCTION );
            }
            if (line.startsWith("மேலும் ")) {
                return new StepMatch("மேலும் ", 7, CONJUNCTION );
            }
            if (line.startsWith("ஆனால் ")) {
                return new StepMatch("ஆனால் ", 6, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Te implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("గుణము")) {
                return new Match("గుణము", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("నేపథ్యం")) {
                return new Match("నేపథ్యం", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("సన్నివేశం")) {
                return new Match("సన్నివేశం", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ఉదాహరణ")) {
                return new Match("ఉదాహరణ", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("కథనం")) {
                return new Match("కథనం", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ఉదాహరణలు")) {
                return new Match("ఉదాహరణలు", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("ఈ పరిస్థితిలో ")) {
                return new StepMatch("ఈ పరిస్థితిలో ", 14, ACTION );
            }
            if (line.startsWith("చెప్పబడినది ")) {
                return new StepMatch("చెప్పబడినది ", 12, CONTEXT );
            }
            if (line.startsWith("అప్పుడు ")) {
                return new StepMatch("అప్పుడు ", 8, OUTCOME );
            }
            if (line.startsWith("మరియు ")) {
                return new StepMatch("మరియు ", 6, CONJUNCTION );
            }
            if (line.startsWith("కాని ")) {
                return new StepMatch("కాని ", 5, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Th implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("ความต้องการทางธุรกิจ")) {
                return new Match("ความต้องการทางธุรกิจ", 20 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ความสามารถ")) {
                return new Match("ความสามารถ", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("โครงหลัก")) {
                return new Match("โครงหลัก", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("แนวคิด")) {
                return new Match("แนวคิด", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("โครงสร้างของเหตุการณ์")) {
                return new Match("โครงสร้างของเหตุการณ์", 21  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("สรุปเหตุการณ์")) {
                return new Match("สรุปเหตุการณ์", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("เหตุการณ์")) {
                return new Match("เหตุการณ์", 9  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ชุดของเหตุการณ์")) {
                return new Match("ชุดของเหตุการณ์", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("ชุดของตัวอย่าง")) {
                return new Match("ชุดของตัวอย่าง", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("กำหนดให้ ")) {
                return new StepMatch("กำหนดให้ ", 9, CONTEXT );
            }
            if (line.startsWith("ดังนั้น ")) {
                return new StepMatch("ดังนั้น ", 8, OUTCOME );
            }
            if (line.startsWith("เมื่อ ")) {
                return new StepMatch("เมื่อ ", 6, ACTION );
            }
            if (line.startsWith("และ ")) {
                return new StepMatch("และ ", 4, CONJUNCTION );
            }
            if (line.startsWith("แต่ ")) {
                return new StepMatch("แต่ ", 4, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Tlh implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("poQbogh malja'")) {
                return new Match("poQbogh malja'", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Qu'meH 'ut")) {
                return new Match("Qu'meH 'ut", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("perbogh")) {
                return new Match("perbogh", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Qap")) {
                return new Match("Qap", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("laH")) {
                return new Match("laH", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("mo'")) {
                return new Match("mo'", 3 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("lut chovnatlh")) {
                return new Match("lut chovnatlh", 13  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("lut")) {
                return new Match("lut", 3  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("ghantoH")) {
                return new Match("ghantoH", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("lutmey")) {
                return new Match("lutmey", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("DaH ghu' bejlu' ")) {
                return new StepMatch("DaH ghu' bejlu' ", 16, CONTEXT );
            }
            if (line.startsWith("ghu' noblu' ")) {
                return new StepMatch("ghu' noblu' ", 12, CONTEXT );
            }
            if (line.startsWith("qaSDI' ")) {
                return new StepMatch("qaSDI' ", 7, ACTION );
            }
            if (line.startsWith("latlh ")) {
                return new StepMatch("latlh ", 6, CONJUNCTION );
            }
            if (line.startsWith("'ach ")) {
                return new StepMatch("'ach ", 5, CONJUNCTION );
            }
            if (line.startsWith("'ej ")) {
                return new StepMatch("'ej ", 4, CONJUNCTION );
            }
            if (line.startsWith("vaj ")) {
                return new StepMatch("vaj ", 4, OUTCOME );
            }
            if (line.startsWith("'a ")) {
                return new StepMatch("'a ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Tr implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Özellik")) {
                return new Match("Özellik", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Geçmiş")) {
                return new Match("Geçmiş", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Kural")) {
                return new Match("Kural", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Senaryo taslağı")) {
                return new Match("Senaryo taslağı", 15  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Senaryo")) {
                return new Match("Senaryo", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Örnek")) {
                return new Match("Örnek", 5  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Örnekler")) {
                return new Match("Örnekler", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Diyelim ki ")) {
                return new StepMatch("Diyelim ki ", 11, CONTEXT );
            }
            if (line.startsWith("O zaman ")) {
                return new StepMatch("O zaman ", 8, OUTCOME );
            }
            if (line.startsWith("Eğer ki ")) {
                return new StepMatch("Eğer ki ", 8, ACTION );
            }
            if (line.startsWith("Fakat ")) {
                return new StepMatch("Fakat ", 6, CONJUNCTION );
            }
            if (line.startsWith("Ama ")) {
                return new StepMatch("Ama ", 4, CONJUNCTION );
            }
            if (line.startsWith("Ve ")) {
                return new StepMatch("Ve ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Tt implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Үзенчәлеклелек")) {
                return new Match("Үзенчәлеклелек", 14 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Мөмкинлек")) {
                return new Match("Мөмкинлек", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Кереш")) {
                return new Match("Кереш", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Сценарийның төзелеше")) {
                return new Match("Сценарийның төзелеше", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарий")) {
                return new Match("Сценарий", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Мисаллар")) {
                return new Match("Мисаллар", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Үрнәкләр")) {
                return new Match("Үрнәкләр", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Нәтиҗәдә ")) {
                return new StepMatch("Нәтиҗәдә ", 9, OUTCOME );
            }
            if (line.startsWith("Әйтик ")) {
                return new StepMatch("Әйтик ", 6, CONTEXT );
            }
            if (line.startsWith("Ләкин ")) {
                return new StepMatch("Ләкин ", 6, CONJUNCTION );
            }
            if (line.startsWith("Әгәр ")) {
                return new StepMatch("Әгәр ", 5, ACTION );
            }
            if (line.startsWith("Әмма ")) {
                return new StepMatch("Әмма ", 5, CONJUNCTION );
            }
            if (line.startsWith("Һәм ")) {
                return new StepMatch("Һәм ", 4, CONJUNCTION );
            }
            if (line.startsWith("Вә ")) {
                return new StepMatch("Вә ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Uk implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функціонал")) {
                return new Match("Функціонал", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Передумова")) {
                return new Match("Передумова", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Структура сценарію")) {
                return new Match("Структура сценарію", 18  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарій")) {
                return new Match("Сценарій", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Приклад")) {
                return new Match("Приклад", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Приклади")) {
                return new Match("Приклади", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Припустимо, що ")) {
                return new StepMatch("Припустимо, що ", 15, CONTEXT );
            }
            if (line.startsWith("Припустимо ")) {
                return new StepMatch("Припустимо ", 11, CONTEXT );
            }
            if (line.startsWith("А також ")) {
                return new StepMatch("А також ", 8, CONJUNCTION );
            }
            if (line.startsWith("Нехай ")) {
                return new StepMatch("Нехай ", 6, CONTEXT );
            }
            if (line.startsWith("Дано ")) {
                return new StepMatch("Дано ", 5, CONTEXT );
            }
            if (line.startsWith("Якщо ")) {
                return new StepMatch("Якщо ", 5, ACTION );
            }
            if (line.startsWith("Коли ")) {
                return new StepMatch("Коли ", 5, ACTION );
            }
            if (line.startsWith("Тоді ")) {
                return new StepMatch("Тоді ", 5, OUTCOME );
            }
            if (line.startsWith("Але ")) {
                return new StepMatch("Але ", 4, CONJUNCTION );
            }
            if (line.startsWith("Та ")) {
                return new StepMatch("Та ", 3, CONJUNCTION );
            }
            if (line.startsWith("То ")) {
                return new StepMatch("То ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("І ")) {
                return new StepMatch("І ", 2, CONJUNCTION );
            }
            return null;
        }
    }
    private static final class Ur implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("کاروبار کی ضرورت")) {
                return new Match("کاروبار کی ضرورت", 16 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("صلاحیت")) {
                return new Match("صلاحیت", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("خصوصیت")) {
                return new Match("خصوصیت", 6 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("پس منظر")) {
                return new Match("پس منظر", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("منظر نامے کا خاکہ")) {
                return new Match("منظر نامے کا خاکہ", 17  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("منظرنامہ")) {
                return new Match("منظرنامہ", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("مثالیں")) {
                return new Match("مثالیں", 6  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("فرض کیا ")) {
                return new StepMatch("فرض کیا ", 8, CONTEXT );
            }
            if (line.startsWith("بالفرض ")) {
                return new StepMatch("بالفرض ", 7, CONTEXT );
            }
            if (line.startsWith("لیکن ")) {
                return new StepMatch("لیکن ", 5, CONJUNCTION );
            }
            if (line.startsWith("پھر ")) {
                return new StepMatch("پھر ", 4, OUTCOME );
            }
            if (line.startsWith("اگر ")) {
                return new StepMatch("اگر ", 4, CONTEXT );
            }
            if (line.startsWith("اور ")) {
                return new StepMatch("اور ", 4, CONJUNCTION );
            }
            if (line.startsWith("جب ")) {
                return new StepMatch("جب ", 3, ACTION );
            }
            if (line.startsWith("تب ")) {
                return new StepMatch("تب ", 3, OUTCOME );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Uz implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Функционал")) {
                return new Match("Функционал", 10 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Тарих")) {
                return new Match("Тарих", 5 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Сценарий структураси")) {
                return new Match("Сценарий структураси", 20  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Сценарий")) {
                return new Match("Сценарий", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Мисоллар")) {
                return new Match("Мисоллар", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Belgilangan ")) {
                return new StepMatch("Belgilangan ", 12, CONTEXT );
            }
            if (line.startsWith("Лекин ")) {
                return new StepMatch("Лекин ", 6, CONJUNCTION );
            }
            if (line.startsWith("Бирок ")) {
                return new StepMatch("Бирок ", 6, CONJUNCTION );
            }
            if (line.startsWith("Унда ")) {
                return new StepMatch("Унда ", 5, OUTCOME );
            }
            if (line.startsWith("Аммо ")) {
                return new StepMatch("Аммо ", 5, CONJUNCTION );
            }
            if (line.startsWith("Агар ")) {
                return new StepMatch("Агар ", 5, ACTION );
            }
            if (line.startsWith("Ва ")) {
                return new StepMatch("Ва ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Vi implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("Tính năng")) {
                return new Match("Tính năng", 9 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("Bối cảnh")) {
                return new Match("Bối cảnh", 8 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Quy tắc")) {
                return new Match("Quy tắc", 7 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("Khung tình huống")) {
                return new Match("Khung tình huống", 16  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Khung kịch bản")) {
                return new Match("Khung kịch bản", 14  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Tình huống")) {
                return new Match("Tình huống", 10  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("Kịch bản")) {
                return new Match("Kịch bản", 8  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Dữ liệu")) {
                return new Match("Dữ liệu", 7  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("Nhưng ")) {
                return new StepMatch("Nhưng ", 6, CONJUNCTION );
            }
            if (line.startsWith("Biết ")) {
                return new StepMatch("Biết ", 5, CONTEXT );
            }
            if (line.startsWith("Thì ")) {
                return new StepMatch("Thì ", 4, OUTCOME );
            }
            if (line.startsWith("Cho ")) {
                return new StepMatch("Cho ", 4, CONTEXT );
            }
            if (line.startsWith("Khi ")) {
                return new StepMatch("Khi ", 4, ACTION );
            }
            if (line.startsWith("Và ")) {
                return new StepMatch("Và ", 3, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            return null;
        }
    }
    private static final class Zh_cn implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("功能")) {
                return new Match("功能", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("背景")) {
                return new Match("背景", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("规则")) {
                return new Match("规则", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("场景大纲")) {
                return new Match("场景大纲", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("剧本大纲")) {
                return new Match("剧本大纲", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("剧本")) {
                return new Match("剧本", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("场景")) {
                return new Match("场景", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("例子")) {
                return new Match("例子", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("同时")) {
                return new StepMatch("同时", 2, CONJUNCTION );
            }
            if (line.startsWith("但是")) {
                return new StepMatch("但是", 2, CONJUNCTION );
            }
            if (line.startsWith("而且")) {
                return new StepMatch("而且", 2, CONJUNCTION );
            }
            if (line.startsWith("假如")) {
                return new StepMatch("假如", 2, CONTEXT );
            }
            if (line.startsWith("那么")) {
                return new StepMatch("那么", 2, OUTCOME );
            }
            if (line.startsWith("并且")) {
                return new StepMatch("并且", 2, CONJUNCTION );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("假定")) {
                return new StepMatch("假定", 2, CONTEXT );
            }
            if (line.startsWith("假设")) {
                return new StepMatch("假设", 2, CONTEXT );
            }
            if (line.startsWith("当")) {
                return new StepMatch("当", 1, ACTION );
            }
            return null;
        }
    }
    private static final class Zh_tw implements KeywordMatcher {
        @Override
        public Match matchFeatureKeyword(Line line) {
            if (line.startsWithTitleKeyword("功能")) {
                return new Match("功能", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchBackgroundKeyword(Line line) {
            if (line.startsWithTitleKeyword("背景")) {
                return new Match("背景", 2 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchRuleKeyword(Line line) {
            if (line.startsWithTitleKeyword("Rule")) {
                return new Match("Rule", 4 + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchScenarioKeyword(Line line) {
            if (line.startsWithTitleKeyword("場景大綱")) {
                return new Match("場景大綱", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("劇本大綱")) {
                return new Match("劇本大綱", 4  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("劇本")) {
                return new Match("劇本", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            if (line.startsWithTitleKeyword("場景")) {
                return new Match("場景", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public Match matchExampleKeyword(Line line) {
            if (line.startsWithTitleKeyword("例子")) {
                return new Match("例子", 2  + TITLE_KEYWORD_SEPARATOR_LENGTH);
            }
            return null;
        }
        @Override
        public StepMatch matchStepKeyword(Line line) {
            if (line.startsWith("但是")) {
                return new StepMatch("但是", 2, CONJUNCTION );
            }
            if (line.startsWith("而且")) {
                return new StepMatch("而且", 2, CONJUNCTION );
            }
            if (line.startsWith("並且")) {
                return new StepMatch("並且", 2, CONJUNCTION );
            }
            if (line.startsWith("那麼")) {
                return new StepMatch("那麼", 2, OUTCOME );
            }
            if (line.startsWith("假設")) {
                return new StepMatch("假設", 2, CONTEXT );
            }
            if (line.startsWith("假如")) {
                return new StepMatch("假如", 2, CONTEXT );
            }
            if (line.startsWith("* ")) {
                return new StepMatch("* ", 2, UNKNOWN );
            }
            if (line.startsWith("假定")) {
                return new StepMatch("假定", 2, CONTEXT );
            }
            if (line.startsWith("同時")) {
                return new StepMatch("同時", 2, CONJUNCTION );
            }
            if (line.startsWith("當")) {
                return new StepMatch("當", 1, ACTION );
            }
            return null;
        }
    }
}
