/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

final class StringUtils {
    private static final IndentedText NO_INDENT_ENTRY = new IndentedText(0, "");

    StringUtils() {
    }

    private static boolean isWhitespaceExcludingNewLine(char c) {
        return c != '\n' && StringUtils.isWhitespace(c);
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || (c < ' ' || c >= '\u1680' && c <= '\u3000') && StringUtils.isWhiteSpaceSlow(c) || c == '\u0085' || c == '\u00a0';
    }

    static boolean isWhiteSpaceSlow(char c) {
        return StringUtils.isCharacterTypeSpace(c) || StringUtils.isDirectionalitySpace(c);
    }

    private static boolean isCharacterTypeSpace(char c) {
        return (28672 >> Character.getType(c) & 1) != 0;
    }

    private static boolean isDirectionalitySpace(char c) {
        return (7168 >> Character.getDirectionality(c) & 1) != 0;
    }

    static IndentedText trimAndIndentKeepNewLines(String input) {
        int end;
        int start;
        int length = input.length();
        if (length == 0) {
            return NO_INDENT_ENTRY;
        }
        for (start = 0; start < length && StringUtils.isWhitespaceExcludingNewLine(input.charAt(start)); ++start) {
        }
        for (end = length; end > start && StringUtils.isWhitespaceExcludingNewLine(input.charAt(end - 1)); --end) {
        }
        String trimmed = input.substring(start, end);
        int indent = input.codePointCount(0, start);
        return new IndentedText(indent, trimmed);
    }

    static IndentedText trimAndIndent(String input) {
        int end;
        int start;
        int length = input.length();
        if (length == 0) {
            return NO_INDENT_ENTRY;
        }
        for (start = 0; start < length && StringUtils.isWhitespace(input.charAt(start)); ++start) {
        }
        for (end = length; end > start && StringUtils.isWhitespace(input.charAt(end - 1)); --end) {
        }
        String trimmed = input.substring(start, end);
        int indent = input.codePointCount(0, start);
        return new IndentedText(indent, trimmed);
    }

    static boolean containsWhitespace(String input, int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!StringUtils.isWhitespace(input.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static String substringAndLeftTrim(String input, int beginIndex, int endIndex) {
        int start;
        for (start = beginIndex; start < endIndex && StringUtils.isWhitespace(input.charAt(start)); ++start) {
        }
        return input.substring(start);
    }

    static final class IndentedText {
        private final int indent;
        private final String text;

        IndentedText(int indent, String text) {
            this.text = text;
            this.indent = indent;
        }

        int getIndent() {
            return this.indent;
        }

        String getText() {
            return this.text;
        }
    }
}

