/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.c21e;

import io.cucumber.c21e.ExeException;
import io.cucumber.c21e.ExeFile;
import io.cucumber.c21e.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class Exe {
    private final ExeFile exeFile;

    public Exe(ExeFile exeFile) {
        this.exeFile = exeFile;
    }

    public InputStream execute(List<String> args, InputStream stdin) throws IOException, InterruptedException {
        File file = this.exeFile.extract();
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(file.getAbsolutePath());
        allArgs.addAll(args);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(allArgs);
        File stderrFile = File.createTempFile("stderr-", ".log");
        stderrFile.deleteOnExit();
        processBuilder.redirectError(stderrFile);
        Process process = processBuilder.start();
        if (stdin != null) {
            OutputStream processStdin = process.getOutputStream();
            IO.copy(stdin, processStdin);
            processStdin.flush();
            processStdin.close();
        }
        InputStream processStdout = process.getInputStream();
        process.waitFor();
        if (process.exitValue() != 0) {
            byte[] stderr = Files.readAllBytes(stderrFile.toPath());
            throw new ExeException(String.format("Error executing %s.\nSTDERR:%s", file.getAbsolutePath(), new String(stderr, StandardCharsets.UTF_8)));
        }
        return processStdout;
    }
}

