/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.c21e;

import io.cucumber.c21e.ExeException;
import io.cucumber.c21e.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;

public class ExeFile {
    private final File exeDir;
    private final Map<Object, Object> props;
    private final String fileName;

    public ExeFile(File exeDir, String fileNamePattern) {
        this(exeDir, fileNamePattern, System.getProperties());
    }

    ExeFile(File exeDir, String executablePattern, Map<Object, Object> props) {
        this.exeDir = exeDir;
        this.props = props;
        this.fileName = executablePattern.replace("{{.OS}}", this.getOs()).replace("{{.Arch}}", this.getArch()).replace("{{.Ext}}", this.getExt());
    }

    private String getExt() {
        return "windows".equals(this.getOs()) ? ".exe" : "";
    }

    public File extract() {
        try {
            InputStream is = this.getInputStream();
            File exeFile = File.createTempFile(this.fileName, "");
            exeFile.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(exeFile);){
                IO.copy(is, os);
                is.close();
            }
            if (!exeFile.setExecutable(true)) {
                throw new ExeException(String.format("Unable to make %s executable", exeFile.getAbsolutePath()));
            }
            return exeFile;
        }
        catch (IOException | SecurityException e) {
            throw new ExeException("Couldn't extract " + this.fileName, e);
        }
    }

    private InputStream getInputStream() throws IOException {
        File file = new File(this.exeDir, this.fileName);
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        InputStream is = this.getClass().getResourceAsStream(String.format("/%s/%s", this.exeDir.getName(), this.fileName));
        if (is != null) {
            return is;
        }
        throw new ExeException(String.format("No gherkin executable for %s. Please submit an issue to https://github.com/cucumber/cucumber/issues", this.fileName));
    }

    private String getOs() {
        return ExeFile.normalizeOs((String)this.props.get("os.name"));
    }

    private String getArch() {
        return ExeFile.normalizeArch((String)this.props.get("os.arch"));
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeArch(String value) {
        if ((value = ExeFile.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "amd64";
        }
        if (value.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "386";
        }
        if (value.matches("^(ia64w?|itanium64)$")) {
            return "itanium_64";
        }
        if ("ia64n".equals(value)) {
            return "itanium_32";
        }
        if (value.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (value.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (value.matches("^(arm|arm32)$")) {
            return "arm";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        if (value.matches("^(mips|mips32)$")) {
            return "mips";
        }
        if (value.matches("^(mipsel|mips32el)$")) {
            return "mipsle";
        }
        if ("mips64".equals(value)) {
            return "mips64";
        }
        if ("mips64el".equals(value)) {
            return "mips64le";
        }
        if (value.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if (value.matches("^(ppcle|ppc32le)$")) {
            return "ppcle_32";
        }
        if ("ppc64".equals(value)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(value)) {
            return "ppcle_64";
        }
        if ("s390".equals(value)) {
            return "s390_32";
        }
        if ("s390x".equals(value)) {
            return "s390x";
        }
        return "unknown";
    }

    private static String normalizeOs(String value) {
        if ((value = ExeFile.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx") || value.startsWith("osx")) {
            return "darwin";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    String getFileName() {
        return this.fileName;
    }
}

