/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.c21e.Exe;
import io.cucumber.c21e.ExeFile;
import io.cucumber.gherkin.GherkinException;
import io.cucumber.gherkin.ProtobufGherkinMessages;
import io.cucumber.messages.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Gherkin {
    private final List<String> paths;
    private final List<Messages.Source> sources;
    private final boolean includeSource;
    private final boolean includeAst;
    private final boolean includePickles;
    static final Exe EXE = new Exe(new ExeFile(new File("gherkin-go"), "gherkin-go-{{.OS}}-{{.Arch}}{{.Ext}}"));

    private Gherkin(List<String> paths, List<Messages.Source> sources, boolean includeSource, boolean includeAst, boolean includePickles) {
        this.paths = paths;
        this.sources = sources;
        this.includeSource = includeSource;
        this.includeAst = includeAst;
        this.includePickles = includePickles;
    }

    public static List<Messages.Wrapper> fromPaths(List<String> paths, boolean includeSource, boolean includeAst, boolean includePickles) {
        return new Gherkin(paths, null, includeSource, includeAst, includePickles).messages();
    }

    public static List<Messages.Wrapper> fromSources(List<Messages.Source> sources, boolean includeSource, boolean includeAst, boolean includePickles) {
        return new Gherkin(Collections.emptyList(), sources, includeSource, includeAst, includePickles).messages();
    }

    public List<Messages.Wrapper> messages() {
        try {
            ArrayList<String> args = new ArrayList<String>();
            if (!this.includeSource) {
                args.add("--no-source");
            }
            if (!this.includeAst) {
                args.add("--no-ast");
            }
            if (!this.includePickles) {
                args.add("--no-pickles");
            }
            args.addAll(this.paths);
            InputStream gherkinStdout = EXE.execute(args, this.getSourcesStream());
            return new ProtobufGherkinMessages(gherkinStdout).messages();
        }
        catch (IOException | InterruptedException e) {
            throw new GherkinException("Couldn't execute gherkin", e);
        }
    }

    private InputStream getSourcesStream() throws IOException {
        if (this.sources == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Messages.Source source : this.sources) {
            Messages.Wrapper.newBuilder().setSource(source).build().writeDelimitedTo(baos);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

