/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class TestCaseStarted {
    private final Long attempt;
    private final String id;
    private final String testCaseId;
    private final String workerId;
    private final Timestamp timestamp;

    public TestCaseStarted(Long attempt, String id, String testCaseId, String workerId, Timestamp timestamp) {
        this.attempt = Objects.requireNonNull(attempt, "TestCaseStarted.attempt cannot be null");
        this.id = Objects.requireNonNull(id, "TestCaseStarted.id cannot be null");
        this.testCaseId = Objects.requireNonNull(testCaseId, "TestCaseStarted.testCaseId cannot be null");
        this.workerId = workerId;
        this.timestamp = Objects.requireNonNull(timestamp, "TestCaseStarted.timestamp cannot be null");
    }

    public Long getAttempt() {
        return this.attempt;
    }

    public String getId() {
        return this.id;
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public Optional<String> getWorkerId() {
        return Optional.ofNullable(this.workerId);
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseStarted that = (TestCaseStarted)o;
        return this.attempt.equals(that.attempt) && this.id.equals(that.id) && this.testCaseId.equals(that.testCaseId) && Objects.equals(this.workerId, that.workerId) && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.attempt, this.id, this.testCaseId, this.workerId, this.timestamp);
    }

    public String toString() {
        return "TestCaseStarted{attempt=" + this.attempt + ", id=" + this.id + ", testCaseId=" + this.testCaseId + ", workerId=" + this.workerId + ", timestamp=" + this.timestamp + '}';
    }
}

