/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.TestStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class TestCase {
    private final String id;
    private final String pickleId;
    private final List<TestStep> testSteps;
    private final String testRunStartedId;

    public TestCase(String id, String pickleId, List<TestStep> testSteps, String testRunStartedId) {
        this.id = Objects.requireNonNull(id, "TestCase.id cannot be null");
        this.pickleId = Objects.requireNonNull(pickleId, "TestCase.pickleId cannot be null");
        this.testSteps = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(testSteps, "TestCase.testSteps cannot be null")));
        this.testRunStartedId = testRunStartedId;
    }

    public String getId() {
        return this.id;
    }

    public String getPickleId() {
        return this.pickleId;
    }

    public List<TestStep> getTestSteps() {
        return this.testSteps;
    }

    public Optional<String> getTestRunStartedId() {
        return Optional.ofNullable(this.testRunStartedId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCase that = (TestCase)o;
        return this.id.equals(that.id) && this.pickleId.equals(that.pickleId) && this.testSteps.equals(that.testSteps) && Objects.equals(this.testRunStartedId, that.testRunStartedId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pickleId, this.testSteps, this.testRunStartedId);
    }

    public String toString() {
        return "TestCase{id=" + this.id + ", pickleId=" + this.pickleId + ", testSteps=" + this.testSteps + ", testRunStartedId=" + this.testRunStartedId + '}';
    }
}

