/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class TestRunHookStarted {
    private final String id;
    private final String testRunStartedId;
    private final String hookId;
    private final String workerId;
    private final Timestamp timestamp;

    public TestRunHookStarted(String id, String testRunStartedId, String hookId, String workerId, Timestamp timestamp) {
        this.id = Objects.requireNonNull(id, "TestRunHookStarted.id cannot be null");
        this.testRunStartedId = Objects.requireNonNull(testRunStartedId, "TestRunHookStarted.testRunStartedId cannot be null");
        this.hookId = Objects.requireNonNull(hookId, "TestRunHookStarted.hookId cannot be null");
        this.workerId = workerId;
        this.timestamp = Objects.requireNonNull(timestamp, "TestRunHookStarted.timestamp cannot be null");
    }

    public String getId() {
        return this.id;
    }

    public String getTestRunStartedId() {
        return this.testRunStartedId;
    }

    public String getHookId() {
        return this.hookId;
    }

    public Optional<String> getWorkerId() {
        return Optional.ofNullable(this.workerId);
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunHookStarted that = (TestRunHookStarted)o;
        return this.id.equals(that.id) && this.testRunStartedId.equals(that.testRunStartedId) && this.hookId.equals(that.hookId) && Objects.equals(this.workerId, that.workerId) && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.testRunStartedId, this.hookId, this.workerId, this.timestamp);
    }

    public String toString() {
        return "TestRunHookStarted{id=" + this.id + ", testRunStartedId=" + this.testRunStartedId + ", hookId=" + this.hookId + ", workerId=" + this.workerId + ", timestamp=" + this.timestamp + '}';
    }
}

