/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.Document;
import java.util.Map;

public class HistoryRecord {
    private final Document doc;

    public HistoryRecord(Document document) {
        this.doc = document;
    }

    public HistoryRecord(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) {
        this.doc = Document.create();
        Document src = this.doc.setDocument("source");
        if (source != null) {
            source.forEach(src::set);
        }
        Document pos = this.doc.setDocument("position");
        if (position != null) {
            position.forEach(pos::set);
        }
        if (databaseName != null) {
            this.doc.setString("databaseName", databaseName);
        }
        if (ddl != null) {
            this.doc.setString("ddl", ddl);
        }
    }

    public Document document() {
        return this.doc;
    }

    protected Document source() {
        return this.doc.getDocument("source");
    }

    protected Document position() {
        return this.doc.getDocument("position");
    }

    protected String databaseName() {
        return this.doc.getString("databaseName");
    }

    protected String ddl() {
        return this.doc.getString("ddl");
    }

    public String toString() {
        return this.doc.toString();
    }

    public boolean isValid() {
        return this.source() != null && this.position() != null;
    }

    public static final class Fields {
        public static final String SOURCE = "source";
        public static final String POSITION = "position";
        public static final String DATABASE_NAME = "databaseName";
        public static final String DDL_STATEMENTS = "ddl";
    }
}

