/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private final ChangeEventQueue<?> queue;
    private final AtomicReference<Throwable> producerThrowable;
    private final CommonConnectorConfig connectorConfig;

    public ErrorHandler(Class<? extends SourceConnector> connectorType, CommonConnectorConfig connectorConfig, ChangeEventQueue<?> queue) {
        this.connectorConfig = connectorConfig;
        this.queue = queue;
        this.producerThrowable = new AtomicReference();
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        LOGGER.error("Producer failure", producerThrowable);
        boolean first = this.producerThrowable.compareAndSet(null, producerThrowable);
        boolean retriable = this.isRetriable(producerThrowable);
        if (!retriable) {
            retriable = this.isCustomRetriable(producerThrowable);
        }
        if (first) {
            if (retriable) {
                this.queue.producerException((RuntimeException)((Object)new RetriableException("An exception occurred in the change event producer. This connector will be restarted.", producerThrowable)));
            } else {
                this.queue.producerException((RuntimeException)new ConnectException("An exception occurred in the change event producer. This connector will be stopped.", producerThrowable));
            }
        }
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    protected boolean isRetriable(Throwable throwable) {
        return false;
    }

    protected boolean isCustomRetriable(Throwable throwable) {
        if (!this.connectorConfig.customRetriableException().isPresent()) {
            return false;
        }
        while (throwable != null) {
            if (throwable.getMessage() != null && throwable.getMessage().matches(this.connectorConfig.customRetriableException().get())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

