/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.manifest;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.BuildServiceFactories;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ResourceRegistry;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.openshift.config.EditableOpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.openshift.decorator.ApplyDeploymentTriggerDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasDecorator;
import io.dekorate.option.config.VcsConfig;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Git;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenshiftManifestGenerator
extends AbstractKubernetesManifestGenerator<OpenshiftConfig>
implements WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    public static final ConfigKey<String> RUNTIME_TYPE = new ConfigKey("RUNTIME_TYPE", String.class);
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final ConfigurationRegistry configurationRegistry;

    public OpenshiftManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        super(resourceRegistry);
        this.configurationRegistry = configurationRegistry;
        resourceRegistry.groups().putIfAbsent(OPENSHIFT, new KubernetesListBuilder());
    }

    public int order() {
        return 300;
    }

    public String getKey() {
        return OPENSHIFT;
    }

    public void generate(OpenshiftConfig config) {
        this.LOGGER.info("Processing openshift configuration.");
        ImageConfiguration imageConfig = OpenshiftManifestGenerator.getImageConfiguration(this.getProject(), config, this.configurationRegistry);
        Optional<DeploymentConfig> existingDeploymentConfig = this.resourceRegistry.groups().getOrDefault(OPENSHIFT, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof DeploymentConfig).map(i -> (DeploymentConfig)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeploymentConfig.isPresent()) {
            this.resourceRegistry.add(OPENSHIFT, (HasMetadata)this.createDeploymentConfig(config, imageConfig));
        }
        if (config.isHeadless()) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        for (Container container : config.getInitContainers()) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        this.addDecorators(OPENSHIFT, config, imageConfig);
    }

    public ConfigurationSupplier<OpenshiftConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((OpenshiftConfigBuilder)new OpenshiftConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    protected void addDecorators(String group, OpenshiftConfig config, ImageConfiguration imageConfig) {
        super.addDecorators(group, (BaseConfig)config);
        if (config.getReplicas() != 1) {
            this.resourceRegistry.decorate(group, (Decorator)new ApplyReplicasDecorator(config.getName(), config.getReplicas()));
        }
        this.resourceRegistry.decorate(group, (Decorator)new ApplyDeploymentTriggerDecorator(config.getName(), imageConfig.getName() + ":" + imageConfig.getVersion()));
        this.resourceRegistry.decorate(group, (Decorator)new AddRouteDecorator(config));
        if (config.hasAttribute(RUNTIME_TYPE)) {
            this.resourceRegistry.decorate(group, (Decorator)new AddLabelDecorator(config.getName(), new Label("app.openshift.io/runtime", (String)config.getAttribute(RUNTIME_TYPE), new String[0])));
        }
        this.resourceRegistry.decorate(group, (Decorator)new RemoveAnnotationDecorator(config.getName(), "app.dekorate.io/vcs-url"));
        Project project = this.getProject();
        Optional vcsConfig = this.configurationRegistry.get(VcsConfig.class);
        String remote = vcsConfig.map(VcsConfig::getRemote).orElse("origin");
        boolean httpsPrefered = vcsConfig.map(VcsConfig::isHttpsPreferred).orElse(false);
        String vcsUrl = project.getScmInfo() != null && Strings.isNotNullOrEmpty((String)((String)project.getScmInfo().getRemote().get("origin"))) ? Git.getRemoteUrl((Path)project.getRoot(), (String)remote, (boolean)httpsPrefered).orElse("<<unknown>>") : "<<unknown>>";
        this.resourceRegistry.decorate(group, (Decorator)new AddVcsUrlAnnotationDecorator(config.getName(), "app.openshift.io/vcs-url", vcsUrl));
        this.resourceRegistry.decorate(group, (Decorator)new AddCommitIdAnnotationDecorator());
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(OpenshiftConfig.class) || type.equals(EditableOpenshiftConfig.class);
    }

    public DeploymentConfig createDeploymentConfig(OpenshiftConfig config, ImageConfiguration imageConfig) {
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(config.getName())).withLabels(Labels.createLabels((BaseConfig)config).stream().collect(Collectors.toMap(l -> l.getKey(), l -> l.getValue())))).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(this.createPodTemplateSpec(config, imageConfig))).endSpec()).build();
    }

    public PodTemplateSpec createPodTemplateSpec(OpenshiftConfig config, ImageConfiguration imageConfig) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(OpenshiftManifestGenerator.createPodSpec(config, imageConfig))).withNewMetadata().endMetadata()).build();
    }

    public static PodSpec createPodSpec(OpenshiftConfig config, ImageConfiguration imageConfig) {
        String image = Images.getImage((String)imageConfig.getRegistry(), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage(image)).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }

    private static ImageConfiguration getImageConfiguration(Project project, OpenshiftConfig config, ConfigurationRegistry configurationRegistry) {
        return configurationRegistry.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> OpenshiftManifestGenerator.merge(config, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)config));
    }

    private static ImageConfiguration merge(OpenshiftConfig config, ImageConfiguration imageConfig) {
        if (config == null) {
            throw new NullPointerException("OpenshiftConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)config);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : config.getProject())).withImage(imageConfig.getImage() != null ? imageConfig.getImage() : null)).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : DEFAULT_REGISTRY)).withName(imageConfig.getName() != null ? imageConfig.getName() : config.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : config.getVersion())).withAutoBuildEnabled(Boolean.valueOf(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false))).withAutoPushEnabled(Boolean.valueOf(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false))).build();
    }
}

