/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.option.annotation.GarbageCollector;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class JvmConfig
extends Configuration {
    private Integer xms;
    private Integer xmx;
    private Boolean server;
    private Boolean useStringDeduplication;
    private Boolean preferIPv4Stack;
    private Boolean heapDumpOnOutOfMemoryError;
    private Boolean useGCOverheadLimit;
    private GarbageCollector gc;
    private SecureRandomSource secureRandom;

    public JvmConfig() {
    }

    public JvmConfig(Project project, Map<ConfigKey, Object> attributes, Integer xms, Integer xmx, Boolean server, Boolean useStringDeduplication, Boolean preferIPv4Stack, Boolean heapDumpOnOutOfMemoryError, Boolean useGCOverheadLimit, GarbageCollector gc, SecureRandomSource secureRandom) {
        super(project, attributes);
        this.xms = xms;
        this.xmx = xmx;
        this.server = server;
        this.useStringDeduplication = useStringDeduplication;
        this.preferIPv4Stack = preferIPv4Stack;
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        this.useGCOverheadLimit = useGCOverheadLimit;
        this.gc = gc;
        this.secureRandom = secureRandom;
    }

    public Integer getXms() {
        return this.xms;
    }

    public Integer getXmx() {
        return this.xmx;
    }

    public Boolean getServer() {
        return this.server;
    }

    public boolean isServer() {
        return this.server != null && this.server != false;
    }

    public Boolean getUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public boolean isUseStringDeduplication() {
        return this.useStringDeduplication != null && this.useStringDeduplication != false;
    }

    public Boolean getPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public boolean isPreferIPv4Stack() {
        return this.preferIPv4Stack != null && this.preferIPv4Stack != false;
    }

    public Boolean getHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public boolean isHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError != null && this.heapDumpOnOutOfMemoryError != false;
    }

    public Boolean getUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public boolean isUseGCOverheadLimit() {
        return this.useGCOverheadLimit != null && this.useGCOverheadLimit != false;
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmConfig that = (JvmConfig)((Object)o);
        if (!Objects.equals(this.xms, that.xms)) {
            return false;
        }
        if (!Objects.equals(this.xmx, that.xmx)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.useStringDeduplication, that.useStringDeduplication)) {
            return false;
        }
        if (!Objects.equals(this.preferIPv4Stack, that.preferIPv4Stack)) {
            return false;
        }
        if (!Objects.equals(this.heapDumpOnOutOfMemoryError, that.heapDumpOnOutOfMemoryError)) {
            return false;
        }
        if (!Objects.equals(this.useGCOverheadLimit, that.useGCOverheadLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.gc, (Object)that.gc)) {
            return false;
        }
        return Objects.equals((Object)this.secureRandom, (Object)that.secureRandom);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.xms, this.xmx, this.server, this.useStringDeduplication, this.preferIPv4Stack, this.heapDumpOnOutOfMemoryError, this.useGCOverheadLimit, this.gc, this.secureRandom, super.hashCode()});
    }
}

