/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.util.concurrent.MoreExecutors;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.ExecutorService;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;

public class DBIHealthCheck
extends HealthCheck {
    private final DBI dbi;
    private final String validationQuery;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public DBIHealthCheck(ExecutorService executorService, Duration duration, DBI dbi, String validationQuery) {
        this.dbi = dbi;
        this.validationQuery = validationQuery;
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public DBIHealthCheck(DBI dbi, String validationQuery) {
        this((ExecutorService)MoreExecutors.newDirectExecutorService(), Duration.seconds((long)0L), dbi, validationQuery);
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            try (Handle handle = this.dbi.open();){
                handle.execute(this.validationQuery, new Object[0]);
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
        });
    }
}

