/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import com.google.common.collect.ImmutableList;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.tweak.ContainerFactory;

public class ImmutableListContainerFactory
implements ContainerFactory<ImmutableList<?>> {
    public boolean accepts(Class<?> type) {
        return ImmutableList.class.isAssignableFrom(type);
    }

    public ContainerBuilder<ImmutableList<?>> newContainerBuilderFor(Class<?> type) {
        return new ImmutableListContainerBuilder();
    }

    private static class ImmutableListContainerBuilder
    implements ContainerBuilder<ImmutableList<?>> {
        private final ImmutableList.Builder<Object> builder = ImmutableList.builder();

        private ImmutableListContainerBuilder() {
        }

        public ContainerBuilder<ImmutableList<?>> add(Object it) {
            this.builder.add(it);
            return this;
        }

        public ImmutableList<?> build() {
            return this.builder.build();
        }
    }
}

