/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.InstantArgument;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class InstantArgumentFactory
implements ArgumentFactory<Instant> {
    private final Optional<Calendar> calendar;

    public InstantArgumentFactory() {
        this(Optional.empty());
    }

    public InstantArgumentFactory(Optional<TimeZone> tz) {
        this.calendar = tz.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof Instant;
    }

    public Argument build(Class<?> expectedType, Instant value, StatementContext ctx) {
        return new InstantArgument(value, this.calendar);
    }
}

