/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Optional;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class ZonedDateTimeArgument
implements Argument {
    private final ZonedDateTime value;
    private final Optional<Calendar> calendar;

    ZonedDateTimeArgument(ZonedDateTime value, Optional<Calendar> calendar) {
        this.value = value;
        this.calendar = calendar;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value != null) {
            if (this.calendar.isPresent()) {
                Calendar calendarClone = (Calendar)this.calendar.get().clone();
                statement.setTimestamp(position, new Timestamp(this.value.toInstant().toEpochMilli()), calendarClone);
            } else {
                statement.setTimestamp(position, new Timestamp(this.value.toInstant().toEpochMilli()));
            }
        } else {
            statement.setNull(position, 93);
        }
    }
}

