/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.junit.ConfigOverride;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DropwizardAppRule<C extends Configuration>
implements TestRule {
    private final Class<? extends Application<C>> applicationClass;
    private final String configPath;
    private C configuration;
    private Application<C> application;
    private Environment environment;
    private Server jettyServer;

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        for (ConfigOverride configOverride : configOverrides) {
            configOverride.addToSystemProperties();
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                DropwizardAppRule.this.startIfRequired();
                try {
                    base.evaluate();
                }
                finally {
                    DropwizardAppRule.this.resetConfigOverrides();
                    DropwizardAppRule.this.jettyServer.stop();
                }
            }
        };
    }

    private void resetConfigOverrides() {
        Enumeration<?> props = System.getProperties().propertyNames();
        while (props.hasMoreElements()) {
            String keyString = (String)props.nextElement();
            if (!keyString.startsWith("dw.")) continue;
            System.clearProperty(keyString);
        }
    }

    private void startIfRequired() {
        if (this.jettyServer != null) {
            return;
        }
        try {
            this.application = this.newApplication();
            Bootstrap bootstrap = new Bootstrap<C>(this.application){

                public void run(C configuration, Environment environment) throws Exception {
                    environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

                        public void serverStarted(Server server) {
                            DropwizardAppRule.this.jettyServer = server;
                        }
                    });
                    DropwizardAppRule.this.configuration = configuration;
                    DropwizardAppRule.this.environment = environment;
                    super.run(configuration, environment);
                }
            };
            this.application.initialize(bootstrap);
            ServerCommand command = new ServerCommand(this.application);
            ImmutableMap.Builder file = ImmutableMap.builder();
            if (!Strings.isNullOrEmpty((String)this.configPath)) {
                file.put((Object)"file", (Object)this.configPath);
            }
            Namespace namespace = new Namespace((Map)file.build());
            command.run(bootstrap, namespace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public int getLocalPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[0]).getLocalPort();
    }

    public int getAdminPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[1]).getLocalPort();
    }

    public Application<C> newApplication() {
        try {
            return this.applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.application;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

