/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5;

import io.dropwizard.metrics5.Counting;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.Reservoir;
import io.dropwizard.metrics5.Sampling;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Summing;
import java.util.concurrent.atomic.LongAdder;

public class Histogram
implements Metric,
Sampling,
Counting,
Summing {
    private final Reservoir reservoir;
    private final LongAdder count;
    private final LongAdder sum;

    public Histogram(Reservoir reservoir) {
        this.reservoir = reservoir;
        this.count = new LongAdder();
        this.sum = new LongAdder();
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.increment();
        this.sum.add(value);
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public long getSum() {
        return this.sum.sum();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }
}

