/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics5.jvm;

import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.MetricSet;
import io.dropwizard.metrics5.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Object> gauges = new HashMap<MetricName, Object>();
        gauges.put(MetricName.build((String[])new String[]{"total.init"}), () -> this.mxBean.getHeapMemoryUsage().getInit() + this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put(MetricName.build((String[])new String[]{"total.used"}), () -> this.mxBean.getHeapMemoryUsage().getUsed() + this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build((String[])new String[]{"total.max"}), () -> this.mxBean.getNonHeapMemoryUsage().getMax() == -1L ? -1L : this.mxBean.getHeapMemoryUsage().getMax() + this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put(MetricName.build((String[])new String[]{"total.committed"}), () -> this.mxBean.getHeapMemoryUsage().getCommitted() + this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build((String[])new String[]{"heap.init"}), () -> this.mxBean.getHeapMemoryUsage().getInit());
        gauges.put(MetricName.build((String[])new String[]{"heap.used"}), () -> this.mxBean.getHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build((String[])new String[]{"heap.max"}), () -> this.mxBean.getHeapMemoryUsage().getMax());
        gauges.put(MetricName.build((String[])new String[]{"heap.committed"}), () -> this.mxBean.getHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build((String[])new String[]{"heap.usage"}), new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of((double)usage.getUsed(), (double)usage.getMax());
            }
        });
        gauges.put(MetricName.build((String[])new String[]{"non-heap.init"}), () -> this.mxBean.getNonHeapMemoryUsage().getInit());
        gauges.put(MetricName.build((String[])new String[]{"non-heap.used"}), () -> this.mxBean.getNonHeapMemoryUsage().getUsed());
        gauges.put(MetricName.build((String[])new String[]{"non-heap.max"}), () -> this.mxBean.getNonHeapMemoryUsage().getMax());
        gauges.put(MetricName.build((String[])new String[]{"non-heap.committed"}), () -> this.mxBean.getNonHeapMemoryUsage().getCommitted());
        gauges.put(MetricName.build((String[])new String[]{"non-heap.usage"}), new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of((double)usage.getUsed(), (double)(usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax()));
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            String poolName = "pools." + WHITESPACE.matcher(pool.getName()).replaceAll("-");
            gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"usage"}), new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage usage = pool.getUsage();
                    return RatioGauge.Ratio.of((double)usage.getUsed(), (double)(usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax()));
                }
            });
            gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"max"}), () -> pool.getUsage().getMax());
            gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"used"}), () -> pool.getUsage().getUsed());
            gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"committed"}), () -> pool.getUsage().getCommitted());
            if (pool.getCollectionUsage() != null) {
                gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"used-after-gc"}), () -> pool.getCollectionUsage().getUsed());
            }
            gauges.put(MetricRegistry.name((String)poolName, (String[])new String[]{"init"}), () -> pool.getUsage().getInit());
        }
        return Collections.unmodifiableMap(gauges);
    }
}

